@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin

import com.pulumi.azurenative.automanage.ConfigurationProfilePreferenceArgs.builder
import com.pulumi.azurenative.automanage.kotlin.inputs.ConfigurationProfilePreferencePropertiesArgs
import com.pulumi.azurenative.automanage.kotlin.inputs.ConfigurationProfilePreferencePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the configuration profile preference.
 * Azure REST API version: 2020-06-30-preview. Prior API version in Azure Native 1.x: 2020-06-30-preview.
 * ## Example Usage
 * ### Create or update configuration profile preference
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfilePreference = new AzureNative.Automanage.ConfigurationProfilePreference("configurationProfilePreference", new()
 *     {
 *         ConfigurationProfilePreferenceName = "defaultProfilePreference",
 *         Location = "East US",
 *         Properties = new AzureNative.Automanage.Inputs.ConfigurationProfilePreferencePropertiesArgs
 *         {
 *             AntiMalware = new AzureNative.Automanage.Inputs.ConfigurationProfilePreferenceAntiMalwareArgs
 *             {
 *                 EnableRealTimeProtection = "True",
 *             },
 *             VmBackup = new AzureNative.Automanage.Inputs.ConfigurationProfilePreferenceVmBackupArgs
 *             {
 *                 TimeZone = "Pacific Standard Time",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *         Tags =
 *         {
 *             { "Organization", "Administration" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automanage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automanage.NewConfigurationProfilePreference(ctx, "configurationProfilePreference", &automanage.ConfigurationProfilePreferenceArgs{
 * 			ConfigurationProfilePreferenceName: pulumi.String("defaultProfilePreference"),
 * 			Location:                           pulumi.String("East US"),
 * 			Properties: automanage.ConfigurationProfilePreferencePropertiesResponse{
 * 				AntiMalware: &automanage.ConfigurationProfilePreferenceAntiMalwareArgs{
 * 					EnableRealTimeProtection: pulumi.String("True"),
 * 				},
 * 				VmBackup: &automanage.ConfigurationProfilePreferenceVmBackupArgs{
 * 					TimeZone: pulumi.String("Pacific Standard Time"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"Organization": pulumi.String("Administration"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automanage.ConfigurationProfilePreference;
 * import com.pulumi.azurenative.automanage.ConfigurationProfilePreferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfilePreference = new ConfigurationProfilePreference("configurationProfilePreference", ConfigurationProfilePreferenceArgs.builder()
 *             .configurationProfilePreferenceName("defaultProfilePreference")
 *             .location("East US")
 *             .properties(Map.ofEntries(
 *                 Map.entry("antiMalware", Map.of("enableRealTimeProtection", "True")),
 *                 Map.entry("vmBackup", Map.of("timeZone", "Pacific Standard Time"))
 *             ))
 *             .resourceGroupName("myResourceGroupName")
 *             .tags(Map.of("Organization", "Administration"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automanage:ConfigurationProfilePreference defaultProfilePreference /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automanage/configurationProfilePreferences/{configurationProfilePreferenceName}
 * ```
 * @property configurationProfilePreferenceName Name of the configuration profile preference.
 * @property location The geo-location where the resource lives
 * @property properties Properties of the configuration profile preference.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ConfigurationProfilePreferenceArgs(
    public val configurationProfilePreferenceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ConfigurationProfilePreferencePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automanage.ConfigurationProfilePreferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.automanage.ConfigurationProfilePreferenceArgs =
        com.pulumi.azurenative.automanage.ConfigurationProfilePreferenceArgs.builder()
            .configurationProfilePreferenceName(
                configurationProfilePreferenceName?.applyValue({ args0 ->
                    args0
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConfigurationProfilePreferenceArgs].
 */
@PulumiTagMarker
public class ConfigurationProfilePreferenceArgsBuilder internal constructor() {
    private var configurationProfilePreferenceName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<ConfigurationProfilePreferencePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the configuration profile preference.
     */
    @JvmName("cjjgpqkuayoowkub")
    public suspend fun configurationProfilePreferenceName(`value`: Output<String>) {
        this.configurationProfilePreferenceName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hldoaaldsdwepgsh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of the configuration profile preference.
     */
    @JvmName("evdwvjrqhxwcjtpq")
    public suspend fun properties(`value`: Output<ConfigurationProfilePreferencePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dapeemcjpylhtyfe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xhkipmspywrrattu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the configuration profile preference.
     */
    @JvmName("dtlljwuqyxxcaoao")
    public suspend fun configurationProfilePreferenceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProfilePreferenceName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("phsqmgmuuslodtjs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of the configuration profile preference.
     */
    @JvmName("hgfwnvbebussqbgb")
    public suspend fun properties(`value`: ConfigurationProfilePreferencePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the configuration profile preference.
     */
    @JvmName("mcibdqxmvnubvapa")
    public suspend
    fun properties(argument: suspend ConfigurationProfilePreferencePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationProfilePreferencePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xheijngnqtljpuxr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("acvuujnbxdjnaxfr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ycdvwvkluyvdotvr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConfigurationProfilePreferenceArgs = ConfigurationProfilePreferenceArgs(
        configurationProfilePreferenceName = configurationProfilePreferenceName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
