@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin

import com.pulumi.azurenative.automanage.ConfigurationProfilesVersionArgs.builder
import com.pulumi.azurenative.automanage.kotlin.inputs.ConfigurationProfilePropertiesArgs
import com.pulumi.azurenative.automanage.kotlin.inputs.ConfigurationProfilePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the configuration profile.
 * Azure REST API version: 2022-05-04.
 * ## Example Usage
 * ### Create or update configuration profile version
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfilesVersion = new AzureNative.Automanage.ConfigurationProfilesVersion("configurationProfilesVersion", new()
 *     {
 *         ConfigurationProfileName = "customConfigurationProfile",
 *         Location = "East US",
 *         Properties = new AzureNative.Automanage.Inputs.ConfigurationProfilePropertiesArgs
 *         {
 *             Configuration =
 *             {
 *                 { "Antimalware/Enable", false },
 *                 { "AzureSecurityCenter/Enable", true },
 *                 { "Backup/Enable", false },
 *                 { "BootDiagnostics/Enable", true },
 *                 { "ChangeTrackingAndInventory/Enable", true },
 *                 { "GuestConfiguration/Enable", true },
 *                 { "LogAnalytics/Enable", true },
 *                 { "UpdateManagement/Enable", true },
 *                 { "VMInsights/Enable", true },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *         Tags =
 *         {
 *             { "Organization", "Administration" },
 *         },
 *         VersionName = "version1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automanage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automanage.NewConfigurationProfilesVersion(ctx, "configurationProfilesVersion", &automanage.ConfigurationProfilesVersionArgs{
 * 			ConfigurationProfileName: pulumi.String("customConfigurationProfile"),
 * 			Location:                 pulumi.String("East US"),
 * 			Properties: &automanage.ConfigurationProfilePropertiesArgs{
 * 				Configuration: pulumi.Any{
 * 					Antimalware / Enable:                false,
 * 					AzureSecurityCenter / Enable:        true,
 * 					Backup / Enable:                     false,
 * 					BootDiagnostics / Enable:            true,
 * 					ChangeTrackingAndInventory / Enable: true,
 * 					GuestConfiguration / Enable:         true,
 * 					LogAnalytics / Enable:               true,
 * 					UpdateManagement / Enable:           true,
 * 					VMInsights / Enable:                 true,
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"Organization": pulumi.String("Administration"),
 * 			},
 * 			VersionName: pulumi.String("version1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automanage.ConfigurationProfilesVersion;
 * import com.pulumi.azurenative.automanage.ConfigurationProfilesVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfilesVersion = new ConfigurationProfilesVersion("configurationProfilesVersion", ConfigurationProfilesVersionArgs.builder()
 *             .configurationProfileName("customConfigurationProfile")
 *             .location("East US")
 *             .properties(Map.of("configuration", Map.ofEntries(
 *                 Map.entry("Antimalware/Enable", false),
 *                 Map.entry("AzureSecurityCenter/Enable", true),
 *                 Map.entry("Backup/Enable", false),
 *                 Map.entry("BootDiagnostics/Enable", true),
 *                 Map.entry("ChangeTrackingAndInventory/Enable", true),
 *                 Map.entry("GuestConfiguration/Enable", true),
 *                 Map.entry("LogAnalytics/Enable", true),
 *                 Map.entry("UpdateManagement/Enable", true),
 *                 Map.entry("VMInsights/Enable", true)
 *             )))
 *             .resourceGroupName("myResourceGroupName")
 *             .tags(Map.of("Organization", "Administration"))
 *             .versionName("version1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automanage:ConfigurationProfilesVersion customConfigurationProfile/version1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automanage/configurationProfiles/{configurationProfileName}/versions/{versionName}
 * ```
 * @property configurationProfileName Name of the configuration profile.
 * @property location The geo-location where the resource lives
 * @property properties Properties of the configuration profile.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property versionName The configuration profile version name.
 */
public data class ConfigurationProfilesVersionArgs(
    public val configurationProfileName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ConfigurationProfilePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val versionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automanage.ConfigurationProfilesVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.automanage.ConfigurationProfilesVersionArgs =
        com.pulumi.azurenative.automanage.ConfigurationProfilesVersionArgs.builder()
            .configurationProfileName(configurationProfileName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .versionName(versionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationProfilesVersionArgs].
 */
@PulumiTagMarker
public class ConfigurationProfilesVersionArgsBuilder internal constructor() {
    private var configurationProfileName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<ConfigurationProfilePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var versionName: Output<String>? = null

    /**
     * @param value Name of the configuration profile.
     */
    @JvmName("jjbafsrrfrjekegl")
    public suspend fun configurationProfileName(`value`: Output<String>) {
        this.configurationProfileName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vtquxetimgypgorp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of the configuration profile.
     */
    @JvmName("sbkyitcjxsiguqke")
    public suspend fun properties(`value`: Output<ConfigurationProfilePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rophctweyaqbyvqa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bpfqsmvvacxvcfdt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The configuration profile version name.
     */
    @JvmName("eclefxjqvsmhgesg")
    public suspend fun versionName(`value`: Output<String>) {
        this.versionName = value
    }

    /**
     * @param value Name of the configuration profile.
     */
    @JvmName("imwxxhxcqwuucbal")
    public suspend fun configurationProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProfileName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pmqgenbrssutqfbx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of the configuration profile.
     */
    @JvmName("jpklducecccmjcag")
    public suspend fun properties(`value`: ConfigurationProfilePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the configuration profile.
     */
    @JvmName("fvdmcwiabjfwvwxs")
    public suspend
    fun properties(argument: suspend ConfigurationProfilePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationProfilePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("snspqjhyrwhourai")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bucjvilwunbpyosj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ejnhhwrucyfugydi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The configuration profile version name.
     */
    @JvmName("pervoabqdablvesa")
    public suspend fun versionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionName = mapped
    }

    internal fun build(): ConfigurationProfilesVersionArgs = ConfigurationProfilesVersionArgs(
        configurationProfileName = configurationProfileName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        versionName = versionName,
    )
}
