@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.inputs

import com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Automanage configuration profile properties.
 * @property configuration configuration dictionary of the configuration profile.
 */
public data class ConfigurationProfilePropertiesArgs(
    public val configuration: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePropertiesArgs =
        com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePropertiesArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationProfilePropertiesArgs].
 */
@PulumiTagMarker
public class ConfigurationProfilePropertiesArgsBuilder internal constructor() {
    private var configuration: Output<Any>? = null

    /**
     * @param value configuration dictionary of the configuration profile.
     */
    @JvmName("ncpwbfvcxuioeult")
    public suspend fun configuration(`value`: Output<Any>) {
        this.configuration = value
    }

    /**
     * @param value configuration dictionary of the configuration profile.
     */
    @JvmName("oaqellfiwoghitbw")
    public suspend fun configuration(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    internal fun build(): ConfigurationProfilePropertiesArgs = ConfigurationProfilePropertiesArgs(
        configuration = configuration,
    )
}
