@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.inputs

import com.pulumi.azurenative.automanage.inputs.GetConfigurationProfilesVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationProfileName The configuration profile name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property versionName The configuration profile version name.
 */
public data class GetConfigurationProfilesVersionPlainArgs(
    public val configurationProfileName: String,
    public val resourceGroupName: String,
    public val versionName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.automanage.inputs.GetConfigurationProfilesVersionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.automanage.inputs.GetConfigurationProfilesVersionPlainArgs =
        com.pulumi.azurenative.automanage.inputs.GetConfigurationProfilesVersionPlainArgs.builder()
            .configurationProfileName(configurationProfileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .versionName(versionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationProfilesVersionPlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationProfilesVersionPlainArgsBuilder internal constructor() {
    private var configurationProfileName: String? = null

    private var resourceGroupName: String? = null

    private var versionName: String? = null

    /**
     * @param value The configuration profile name.
     */
    @JvmName("roxtmsebcejjyvsx")
    public suspend fun configurationProfileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationProfileName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("smjrreptjclksdol")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The configuration profile version name.
     */
    @JvmName("uwpoanyxtceenavh")
    public suspend fun versionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.versionName = mapped
    }

    internal fun build(): GetConfigurationProfilesVersionPlainArgs =
        GetConfigurationProfilesVersionPlainArgs(
            configurationProfileName = configurationProfileName ?: throw
                PulumiNullFieldException("configurationProfileName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            versionName = versionName ?: throw PulumiNullFieldException("versionName"),
        )
}
