@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity for the Automanage account.
 * @property principalId The principal id of Automanage account identity.
 * @property tenantId The tenant id associated with the Automanage account.
 * @property type The type of identity used for the Automanage account. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity.
 */
public data class AccountIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automanage.outputs.AccountIdentityResponse):
            AccountIdentityResponse = AccountIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
