@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.CertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of the certificate.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update a certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificate = new AzureNative.Automation.Certificate("certificate", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount18",
 *         Base64Value = "base 64 value of cert",
 *         CertificateName = "testCert",
 *         Description = "Sample Cert",
 *         IsExportable = false,
 *         Name = "testCert",
 *         ResourceGroupName = "rg",
 *         Thumbprint = "thumbprint of cert",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewCertificate(ctx, "certificate", &automation.CertificateArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount18"),
 * 			Base64Value:           pulumi.String("base 64 value of cert"),
 * 			CertificateName:       pulumi.String("testCert"),
 * 			Description:           pulumi.String("Sample Cert"),
 * 			IsExportable:          pulumi.Bool(false),
 * 			Name:                  pulumi.String("testCert"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			Thumbprint:            pulumi.String("thumbprint of cert"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Certificate;
 * import com.pulumi.azurenative.automation.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificate = new Certificate("certificate", CertificateArgs.builder()
 *             .automationAccountName("myAutomationAccount18")
 *             .base64Value("base 64 value of cert")
 *             .certificateName("testCert")
 *             .description("Sample Cert")
 *             .isExportable(false)
 *             .name("testCert")
 *             .resourceGroupName("rg")
 *             .thumbprint("thumbprint of cert")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Certificate testCert /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/certificates/{certificateName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property base64Value Gets or sets the base64 encoded value of the certificate.
 * @property certificateName The parameters supplied to the create or update certificate operation.
 * @property description Gets or sets the description of the certificate.
 * @property isExportable Gets or sets the is exportable flag of the certificate.
 * @property name Gets or sets the name of the certificate.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property thumbprint Gets or sets the thumbprint of the certificate.
 */
public data class CertificateArgs(
    public val automationAccountName: Output<String>? = null,
    public val base64Value: Output<String>? = null,
    public val certificateName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val isExportable: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val thumbprint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.CertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.CertificateArgs =
        com.pulumi.azurenative.automation.CertificateArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .base64Value(base64Value?.applyValue({ args0 -> args0 }))
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .isExportable(isExportable?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .thumbprint(thumbprint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateArgs].
 */
@PulumiTagMarker
public class CertificateArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var base64Value: Output<String>? = null

    private var certificateName: Output<String>? = null

    private var description: Output<String>? = null

    private var isExportable: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var thumbprint: Output<String>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("mpbthpcrcxnjjrqd")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Gets or sets the base64 encoded value of the certificate.
     */
    @JvmName("sisprfpvcbnnafwi")
    public suspend fun base64Value(`value`: Output<String>) {
        this.base64Value = value
    }

    /**
     * @param value The parameters supplied to the create or update certificate operation.
     */
    @JvmName("fpdfukccsyfbvexc")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value Gets or sets the description of the certificate.
     */
    @JvmName("ggtuafrwwsmdbuak")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets the is exportable flag of the certificate.
     */
    @JvmName("leudupkhjpfjkkuj")
    public suspend fun isExportable(`value`: Output<Boolean>) {
        this.isExportable = value
    }

    /**
     * @param value Gets or sets the name of the certificate.
     */
    @JvmName("orwycgobtioivpdm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("tioupnqihkjefmef")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the thumbprint of the certificate.
     */
    @JvmName("gkycnvxtqhvcjnkb")
    public suspend fun thumbprint(`value`: Output<String>) {
        this.thumbprint = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("unhrjwxkwfneqluy")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Gets or sets the base64 encoded value of the certificate.
     */
    @JvmName("sjfoobflifoabxlg")
    public suspend fun base64Value(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.base64Value = mapped
    }

    /**
     * @param value The parameters supplied to the create or update certificate operation.
     */
    @JvmName("haxuaktywcchcruy")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value Gets or sets the description of the certificate.
     */
    @JvmName("smaptgulvjvfgyik")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets the is exportable flag of the certificate.
     */
    @JvmName("cscyildhwljjcjjo")
    public suspend fun isExportable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isExportable = mapped
    }

    /**
     * @param value Gets or sets the name of the certificate.
     */
    @JvmName("yhqatwsiwragbrwi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("roagwbyykrctydtp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the thumbprint of the certificate.
     */
    @JvmName("xlbyxtnefpbblhuh")
    public suspend fun thumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbprint = mapped
    }

    internal fun build(): CertificateArgs = CertificateArgs(
        automationAccountName = automationAccountName,
        base64Value = base64Value,
        certificateName = certificateName,
        description = description,
        isExportable = isExportable,
        name = name,
        resourceGroupName = resourceGroupName,
        thumbprint = thumbprint,
    )
}
