@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.ConnectionArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.ConnectionTypeAssociationPropertyArgs
import com.pulumi.azurenative.automation.kotlin.inputs.ConnectionTypeAssociationPropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the connection.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connection = new AzureNative.Automation.Connection("connection", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount28",
 *         ConnectionName = "mysConnection",
 *         ConnectionType = new AzureNative.Automation.Inputs.ConnectionTypeAssociationPropertyArgs
 *         {
 *             Name = "Azure",
 *         },
 *         Description = "my description goes here",
 *         FieldDefinitionValues =
 *         {
 *             { "AutomationCertificateName", "mysCertificateName" },
 *             { "SubscriptionID", "subid" },
 *         },
 *         Name = "mysConnection",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewConnection(ctx, "connection", &automation.ConnectionArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount28"),
 * 			ConnectionName:        pulumi.String("mysConnection"),
 * 			ConnectionType: &automation.ConnectionTypeAssociationPropertyArgs{
 * 				Name: pulumi.String("Azure"),
 * 			},
 * 			Description: pulumi.String("my description goes here"),
 * 			FieldDefinitionValues: pulumi.StringMap{
 * 				"AutomationCertificateName": pulumi.String("mysCertificateName"),
 * 				"SubscriptionID":            pulumi.String("subid"),
 * 			},
 * 			Name:              pulumi.String("mysConnection"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Connection;
 * import com.pulumi.azurenative.automation.ConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connection = new Connection("connection", ConnectionArgs.builder()
 *             .automationAccountName("myAutomationAccount28")
 *             .connectionName("mysConnection")
 *             .connectionType(Map.of("name", "Azure"))
 *             .description("my description goes here")
 *             .fieldDefinitionValues(Map.ofEntries(
 *                 Map.entry("AutomationCertificateName", "mysCertificateName"),
 *                 Map.entry("SubscriptionID", "subid")
 *             ))
 *             .name("mysConnection")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Connection mysConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/connections/{connectionName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property connectionName The parameters supplied to the create or update connection operation.
 * @property connectionType Gets or sets the connectionType of the connection.
 * @property description Gets or sets the description of the connection.
 * @property fieldDefinitionValues Gets or sets the field definition properties of the connection.
 * @property name Gets or sets the name of the connection.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class ConnectionArgs(
    public val automationAccountName: Output<String>? = null,
    public val connectionName: Output<String>? = null,
    public val connectionType: Output<ConnectionTypeAssociationPropertyArgs>? = null,
    public val description: Output<String>? = null,
    public val fieldDefinitionValues: Output<Map<String, String>>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.ConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.ConnectionArgs =
        com.pulumi.azurenative.automation.ConnectionArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .connectionType(connectionType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fieldDefinitionValues(
                fieldDefinitionValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionArgs].
 */
@PulumiTagMarker
public class ConnectionArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var connectionName: Output<String>? = null

    private var connectionType: Output<ConnectionTypeAssociationPropertyArgs>? = null

    private var description: Output<String>? = null

    private var fieldDefinitionValues: Output<Map<String, String>>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("heisdnaukpctlrcn")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value The parameters supplied to the create or update connection operation.
     */
    @JvmName("dsqrijnietktggux")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value Gets or sets the connectionType of the connection.
     */
    @JvmName("sfqhrmshwvwnlrtl")
    public suspend fun connectionType(`value`: Output<ConnectionTypeAssociationPropertyArgs>) {
        this.connectionType = value
    }

    /**
     * @param value Gets or sets the description of the connection.
     */
    @JvmName("ljuvgjwuwvxoqtvr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets the field definition properties of the connection.
     */
    @JvmName("ucltodcmetiuhpeo")
    public suspend fun fieldDefinitionValues(`value`: Output<Map<String, String>>) {
        this.fieldDefinitionValues = value
    }

    /**
     * @param value Gets or sets the name of the connection.
     */
    @JvmName("vtupaiulbovnqokj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("bwuecmmmgcfybpln")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("dgidnwcmyfcuhees")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value The parameters supplied to the create or update connection operation.
     */
    @JvmName("hwcqsivlhostyxaa")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value Gets or sets the connectionType of the connection.
     */
    @JvmName("jocrtstccswmubyi")
    public suspend fun connectionType(`value`: ConnectionTypeAssociationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionType = mapped
    }

    /**
     * @param argument Gets or sets the connectionType of the connection.
     */
    @JvmName("mrghewswuxkyreiw")
    public suspend
    fun connectionType(argument: suspend ConnectionTypeAssociationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionTypeAssociationPropertyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.connectionType = mapped
    }

    /**
     * @param value Gets or sets the description of the connection.
     */
    @JvmName("unkfowcmqspdlhiy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets the field definition properties of the connection.
     */
    @JvmName("gpoefcqsqcdgfjxd")
    public suspend fun fieldDefinitionValues(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldDefinitionValues = mapped
    }

    /**
     * @param values Gets or sets the field definition properties of the connection.
     */
    @JvmName("kgmmfdbkoqpvhjng")
    public fun fieldDefinitionValues(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldDefinitionValues = mapped
    }

    /**
     * @param value Gets or sets the name of the connection.
     */
    @JvmName("tlderexleihedalm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("sdmmrxkipqeythff")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ConnectionArgs = ConnectionArgs(
        automationAccountName = automationAccountName,
        connectionName = connectionName,
        connectionType = connectionType,
        description = description,
        fieldDefinitionValues = fieldDefinitionValues,
        name = name,
        resourceGroupName = resourceGroupName,
    )
}
