@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.kotlin.outputs.RunbookAssociationPropertyResponse
import com.pulumi.azurenative.automation.kotlin.outputs.ScheduleAssociationPropertyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.automation.kotlin.outputs.RunbookAssociationPropertyResponse.Companion.toKotlin as runbookAssociationPropertyResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.ScheduleAssociationPropertyResponse.Companion.toKotlin as scheduleAssociationPropertyResponseToKotlin

/**
 * Builder for [JobSchedule].
 */
@PulumiTagMarker
public class JobScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobScheduleArgs = JobScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobScheduleArgsBuilder.() -> Unit) {
        val builder = JobScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): JobSchedule {
        val builtJavaResource = com.pulumi.azurenative.automation.JobSchedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JobSchedule(builtJavaResource)
    }
}

/**
 * Definition of the job schedule.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create a job schedule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobSchedule = new AzureNative.Automation.JobSchedule("jobSchedule", new()
 *     {
 *         AutomationAccountName = "ContoseAutomationAccount",
 *         JobScheduleId = "0fa462ba-3aa2-4138-83ca-9ebc3bc55cdc",
 *         Parameters =
 *         {
 *             { "jobscheduletag01", "jobschedulevalue01" },
 *             { "jobscheduletag02", "jobschedulevalue02" },
 *         },
 *         ResourceGroupName = "rg",
 *         Runbook = new AzureNative.Automation.Inputs.RunbookAssociationPropertyArgs
 *         {
 *             Name = "TestRunbook",
 *         },
 *         Schedule = new AzureNative.Automation.Inputs.ScheduleAssociationPropertyArgs
 *         {
 *             Name = "ScheduleNameGoesHere332204b5-debe-4348-a5c7-6357457189f2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewJobSchedule(ctx, "jobSchedule", &automation.JobScheduleArgs{
 * 			AutomationAccountName: pulumi.String("ContoseAutomationAccount"),
 * 			JobScheduleId:         pulumi.String("0fa462ba-3aa2-4138-83ca-9ebc3bc55cdc"),
 * 			Parameters: pulumi.StringMap{
 * 				"jobscheduletag01": pulumi.String("jobschedulevalue01"),
 * 				"jobscheduletag02": pulumi.String("jobschedulevalue02"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			Runbook: &automation.RunbookAssociationPropertyArgs{
 * 				Name: pulumi.String("TestRunbook"),
 * 			},
 * 			Schedule: &automation.ScheduleAssociationPropertyArgs{
 * 				Name: pulumi.String("ScheduleNameGoesHere332204b5-debe-4348-a5c7-6357457189f2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.JobSchedule;
 * import com.pulumi.azurenative.automation.JobScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobSchedule = new JobSchedule("jobSchedule", JobScheduleArgs.builder()
 *             .automationAccountName("ContoseAutomationAccount")
 *             .jobScheduleId("0fa462ba-3aa2-4138-83ca-9ebc3bc55cdc")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("jobscheduletag01", "jobschedulevalue01"),
 *                 Map.entry("jobscheduletag02", "jobschedulevalue02")
 *             ))
 *             .resourceGroupName("rg")
 *             .runbook(Map.of("name", "TestRunbook"))
 *             .schedule(Map.of("name", "ScheduleNameGoesHere332204b5-debe-4348-a5c7-6357457189f2"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:JobSchedule myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobSchedules/{jobScheduleId}
 * ```
 */
public class JobSchedule internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.JobSchedule,
) : KotlinCustomResource(javaResource, JobScheduleMapper) {
    /**
     * Gets or sets the id of job schedule.
     */
    public val jobScheduleId: Output<String>?
        get() = javaResource.jobScheduleId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the name of the variable.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the parameters of the job schedule.
     */
    public val parameters: Output<Map<String, String>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the hybrid worker group that the scheduled job should run on.
     */
    public val runOn: Output<String>?
        get() = javaResource.runOn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the runbook.
     */
    public val runbook: Output<RunbookAssociationPropertyResponse>?
        get() = javaResource.runbook().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    runbookAssociationPropertyResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the schedule.
     */
    public val schedule: Output<ScheduleAssociationPropertyResponse>?
        get() = javaResource.schedule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    scheduleAssociationPropertyResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JobScheduleMapper : ResourceMapper<JobSchedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.JobSchedule::class == javaResource::class

    override fun map(javaResource: Resource): JobSchedule = JobSchedule(
        javaResource as
            com.pulumi.azurenative.automation.JobSchedule,
    )
}

/**
 * @see [JobSchedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobSchedule].
 */
public suspend fun jobSchedule(name: String, block: suspend JobScheduleResourceBuilder.() -> Unit):
    JobSchedule {
    val builder = JobScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobSchedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobSchedule(name: String): JobSchedule {
    val builder = JobScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
