@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.kotlin.outputs.ErrorResponseResponse
import com.pulumi.azurenative.automation.kotlin.outputs.SUCSchedulePropertiesResponse
import com.pulumi.azurenative.automation.kotlin.outputs.SoftwareUpdateConfigurationTasksResponse
import com.pulumi.azurenative.automation.kotlin.outputs.UpdateConfigurationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.automation.kotlin.outputs.ErrorResponseResponse.Companion.toKotlin as errorResponseResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.SUCSchedulePropertiesResponse.Companion.toKotlin as sUCSchedulePropertiesResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.SoftwareUpdateConfigurationTasksResponse.Companion.toKotlin as softwareUpdateConfigurationTasksResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.UpdateConfigurationResponse.Companion.toKotlin as updateConfigurationResponseToKotlin

/**
 * Builder for [SoftwareUpdateConfigurationByName].
 */
@PulumiTagMarker
public class SoftwareUpdateConfigurationByNameResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SoftwareUpdateConfigurationByNameArgs = SoftwareUpdateConfigurationByNameArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SoftwareUpdateConfigurationByNameArgsBuilder.() -> Unit) {
        val builder = SoftwareUpdateConfigurationByNameArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SoftwareUpdateConfigurationByName {
        val builtJavaResource =
            com.pulumi.azurenative.automation.SoftwareUpdateConfigurationByName(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SoftwareUpdateConfigurationByName(builtJavaResource)
    }
}

/**
 * Software update configuration properties.
 * Azure REST API version: 2019-06-01. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2017-05-15-preview, 2023-05-15-preview.
 * ## Example Usage
 * ### Create software update configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var softwareUpdateConfigurationByName = new AzureNative.Automation.SoftwareUpdateConfigurationByName("softwareUpdateConfigurationByName", new()
 *     {
 *         AutomationAccountName = "myaccount",
 *         ResourceGroupName = "mygroup",
 *         ScheduleInfo = new AzureNative.Automation.Inputs.SUCSchedulePropertiesArgs
 *         {
 *             AdvancedSchedule = new AzureNative.Automation.Inputs.AdvancedScheduleArgs
 *             {
 *                 WeekDays = new[]
 *                 {
 *                     "Monday",
 *                     "Thursday",
 *                 },
 *             },
 *             ExpiryTime = "2018-11-09T11:22:57+00:00",
 *             Frequency = "Hour",
 *             Interval = 1,
 *             StartTime = "2017-10-19T12:22:57+00:00",
 *             TimeZone = "America/Los_Angeles",
 *         },
 *         SoftwareUpdateConfigurationName = "testpatch",
 *         Tasks = new AzureNative.Automation.Inputs.SoftwareUpdateConfigurationTasksArgs
 *         {
 *             PostTask = new AzureNative.Automation.Inputs.TaskPropertiesArgs
 *             {
 *                 Source = "GetCache",
 *             },
 *             PreTask = new AzureNative.Automation.Inputs.TaskPropertiesArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "COMPUTERNAME", "Computer1" },
 *                 },
 *                 Source = "HelloWorld",
 *             },
 *         },
 *         UpdateConfiguration = new AzureNative.Automation.Inputs.UpdateConfigurationArgs
 *         {
 *             AzureVirtualMachines = new[]
 *             {
 *                 "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-01",
 *                 "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-02",
 *                 "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-03",
 *             },
 *             Duration = "PT2H0M",
 *             NonAzureComputerNames = new[]
 *             {
 *                 "box1.contoso.com",
 *                 "box2.contoso.com",
 *             },
 *             OperatingSystem = AzureNative.Automation.OperatingSystemType.Windows,
 *             Targets = new AzureNative.Automation.Inputs.TargetPropertiesArgs
 *             {
 *                 AzureQueries = new[]
 *                 {
 *                     new AzureNative.Automation.Inputs.AzureQueryPropertiesArgs
 *                     {
 *                         Locations = new[]
 *                         {
 *                             "Japan East",
 *                             "UK South",
 *                         },
 *                         Scope = new[]
 *                         {
 *                             "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources",
 *                             "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067",
 *                         },
 *                         TagSettings = new AzureNative.Automation.Inputs.TagSettingsPropertiesArgs
 *                         {
 *                             FilterOperator = AzureNative.Automation.TagOperators.All,
 *                             Tags =
 *                             {
 *                                 { "tag1", new[]
 *                                 {
 *                                     "tag1Value1",
 *                                     "tag1Value2",
 *                                     "tag1Value3",
 *                                 } },
 *                                 { "tag2", new[]
 *                                 {
 *                                     "tag2Value1",
 *                                     "tag2Value2",
 *                                     "tag2Value3",
 *                                 } },
 *                             },
 *                         },
 *                     },
 *                 },
 *                 NonAzureQueries = new[]
 *                 {
 *                     new AzureNative.Automation.Inputs.NonAzureQueryPropertiesArgs
 *                     {
 *                         FunctionAlias = "SavedSearch1",
 *                         WorkspaceId = "WorkspaceId1",
 *                     },
 *                     new AzureNative.Automation.Inputs.NonAzureQueryPropertiesArgs
 *                     {
 *                         FunctionAlias = "SavedSearch2",
 *                         WorkspaceId = "WorkspaceId2",
 *                     },
 *                 },
 *             },
 *             Windows = new AzureNative.Automation.Inputs.WindowsPropertiesArgs
 *             {
 *                 ExcludedKbNumbers = new[]
 *                 {
 *                     "168934",
 *                     "168973",
 *                 },
 *                 IncludedUpdateClassifications = "Critical",
 *                 RebootSetting = "IfRequired",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := automation.NewSoftwareUpdateConfigurationByName(ctx, "softwareUpdateConfigurationByName", &automation.SoftwareUpdateConfigurationByNameArgs{
 * AutomationAccountName: pulumi.String("myaccount"),
 * ResourceGroupName: pulumi.String("mygroup"),
 * ScheduleInfo: automation.SUCSchedulePropertiesResponse{
 * AdvancedSchedule: &automation.AdvancedScheduleArgs{
 * WeekDays: pulumi.StringArray{
 * pulumi.String("Monday"),
 * pulumi.String("Thursday"),
 * },
 * },
 * ExpiryTime: pulumi.String("2018-11-09T11:22:57+00:00"),
 * Frequency: pulumi.String("Hour"),
 * Interval: pulumi.Float64(1),
 * StartTime: pulumi.String("2017-10-19T12:22:57+00:00"),
 * TimeZone: pulumi.String("America/Los_Angeles"),
 * },
 * SoftwareUpdateConfigurationName: pulumi.String("testpatch"),
 * Tasks: automation.SoftwareUpdateConfigurationTasksResponse{
 * PostTask: &automation.TaskPropertiesArgs{
 * Source: pulumi.String("GetCache"),
 * },
 * PreTask: &automation.TaskPropertiesArgs{
 * Parameters: pulumi.StringMap{
 * "COMPUTERNAME": pulumi.String("Computer1"),
 * },
 * Source: pulumi.String("HelloWorld"),
 * },
 * },
 * UpdateConfiguration: automation.UpdateConfigurationResponse{
 * AzureVirtualMachines: pulumi.StringArray{
 * pulumi.String("/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-01"),
 * pulumi.String("/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-02"),
 * pulumi.String("/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-03"),
 * },
 * Duration: pulumi.String("PT2H0M"),
 * NonAzureComputerNames: pulumi.StringArray{
 * pulumi.String("box1.contoso.com"),
 * pulumi.String("box2.contoso.com"),
 * },
 * OperatingSystem: automation.OperatingSystemTypeWindows,
 * Targets: interface{}{
 * AzureQueries: automation.AzureQueryPropertiesArray{
 * interface{}{
 * Locations: pulumi.StringArray{
 * pulumi.String("Japan East"),
 * pulumi.String("UK South"),
 * },
 * Scope: pulumi.StringArray{
 * pulumi.String("/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources"),
 * pulumi.String("/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067"),
 * },
 * TagSettings: &automation.TagSettingsPropertiesArgs{
 * FilterOperator: automation.TagOperatorsAll,
 * Tags: pulumi.StringArrayMap{
 * "tag1": pulumi.StringArray{
 * pulumi.String("tag1Value1"),
 * pulumi.String("tag1Value2"),
 * pulumi.String("tag1Value3"),
 * },
 * "tag2": pulumi.StringArray{
 * pulumi.String("tag2Value1"),
 * pulumi.String("tag2Value2"),
 * pulumi.String("tag2Value3"),
 * },
 * },
 * },
 * },
 * },
 * NonAzureQueries: automation.NonAzureQueryPropertiesArray{
 * &automation.NonAzureQueryPropertiesArgs{
 * FunctionAlias: pulumi.String("SavedSearch1"),
 * WorkspaceId: pulumi.String("WorkspaceId1"),
 * },
 * &automation.NonAzureQueryPropertiesArgs{
 * FunctionAlias: pulumi.String("SavedSearch2"),
 * WorkspaceId: pulumi.String("WorkspaceId2"),
 * },
 * },
 * },
 * Windows: &automation.WindowsPropertiesArgs{
 * ExcludedKbNumbers: pulumi.StringArray{
 * pulumi.String("168934"),
 * pulumi.String("168973"),
 * },
 * IncludedUpdateClassifications: pulumi.String("Critical"),
 * RebootSetting: pulumi.String("IfRequired"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.SoftwareUpdateConfigurationByName;
 * import com.pulumi.azurenative.automation.SoftwareUpdateConfigurationByNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var softwareUpdateConfigurationByName = new SoftwareUpdateConfigurationByName("softwareUpdateConfigurationByName", SoftwareUpdateConfigurationByNameArgs.builder()
 *             .automationAccountName("myaccount")
 *             .resourceGroupName("mygroup")
 *             .scheduleInfo(Map.ofEntries(
 *                 Map.entry("advancedSchedule", Map.of("weekDays",
 *                     "Monday",
 *                     "Thursday")),
 *                 Map.entry("expiryTime", "2018-11-09T11:22:57+00:00"),
 *                 Map.entry("frequency", "Hour"),
 *                 Map.entry("interval", 1),
 *                 Map.entry("startTime", "2017-10-19T12:22:57+00:00"),
 *                 Map.entry("timeZone", "America/Los_Angeles")
 *             ))
 *             .softwareUpdateConfigurationName("testpatch")
 *             .tasks(Map.ofEntries(
 *                 Map.entry("postTask", Map.of("source", "GetCache")),
 *                 Map.entry("preTask", Map.ofEntries(
 *                     Map.entry("parameters", Map.of("COMPUTERNAME", "Computer1")),
 *                     Map.entry("source", "HelloWorld")
 *                 ))
 *             ))
 *             .updateConfiguration(Map.ofEntries(
 *                 Map.entry("azureVirtualMachines",
 *                     "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-01",
 *                     "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-02",
 *                     "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources/providers/Microsoft.Compute/virtualMachines/vm-03"),
 *                 Map.entry("duration", "PT2H0M"),
 *                 Map.entry("nonAzureComputerNames",
 *                     "box1.contoso.com",
 *                     "box2.contoso.com"),
 *                 Map.entry("operatingSystem", "Windows"),
 *                 Map.entry("targets", Map.ofEntries(
 *                     Map.entry("azureQueries", Map.ofEntries(
 *                         Map.entry("locations",
 *                             "Japan East",
 *                             "UK South"),
 *                         Map.entry("scope",
 *                             "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067/resourceGroups/myresources",
 *                             "/subscriptions/5ae68d89-69a4-454f-b5ce-e443cc4e0067"),
 *                         Map.entry("tagSettings", Map.ofEntries(
 *                             Map.entry("filterOperator", "All"),
 *                             Map.entry("tags", Map.ofEntries(
 *                                 Map.entry("tag1",
 *                                     "tag1Value1",
 *                                     "tag1Value2",
 *                                     "tag1Value3"),
 *                                 Map.entry("tag2",
 *                                     "tag2Value1",
 *                                     "tag2Value2",
 *                                     "tag2Value3")
 *                             ))
 *                         ))
 *                     )),
 *                     Map.entry("nonAzureQueries",
 *                         Map.ofEntries(
 *                             Map.entry("functionAlias", "SavedSearch1"),
 *                             Map.entry("workspaceId", "WorkspaceId1")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("functionAlias", "SavedSearch2"),
 *                             Map.entry("workspaceId", "WorkspaceId2")
 *                         ))
 *                 )),
 *                 Map.entry("windows", Map.ofEntries(
 *                     Map.entry("excludedKbNumbers",
 *                         "168934",
 *                         "168973"),
 *                     Map.entry("includedUpdateClassifications", "Critical"),
 *                     Map.entry("rebootSetting", "IfRequired")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:SoftwareUpdateConfigurationByName testpatch /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurations/{softwareUpdateConfigurationName}
 * ```
 */
public class SoftwareUpdateConfigurationByName internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.SoftwareUpdateConfigurationByName,
) : KotlinCustomResource(javaResource, SoftwareUpdateConfigurationByNameMapper) {
    /**
     * CreatedBy property, which only appears in the response.
     */
    public val createdBy: Output<String>
        get() = javaResource.createdBy().applyValue({ args0 -> args0 })

    /**
     * Creation time of the resource, which only appears in the response.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * Details of provisioning error
     */
    public val error: Output<ErrorResponseResponse>?
        get() = javaResource.error().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    errorResponseResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * LastModifiedBy property, which only appears in the response.
     */
    public val lastModifiedBy: Output<String>
        get() = javaResource.lastModifiedBy().applyValue({ args0 -> args0 })

    /**
     * Last time resource was modified, which only appears in the response.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state for the software update configuration, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Schedule information for the Software update configuration
     */
    public val scheduleInfo: Output<SUCSchedulePropertiesResponse>
        get() = javaResource.scheduleInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                sUCSchedulePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Tasks information for the Software update configuration.
     */
    public val tasks: Output<SoftwareUpdateConfigurationTasksResponse>?
        get() = javaResource.tasks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    softwareUpdateConfigurationTasksResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * update specific properties for the Software update configuration
     */
    public val updateConfiguration: Output<UpdateConfigurationResponse>
        get() = javaResource.updateConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                updateConfigurationResponseToKotlin(args0)
            })
        })
}

public object SoftwareUpdateConfigurationByNameMapper :
    ResourceMapper<SoftwareUpdateConfigurationByName> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.SoftwareUpdateConfigurationByName::class == javaResource::class

    override fun map(javaResource: Resource): SoftwareUpdateConfigurationByName =
        SoftwareUpdateConfigurationByName(
            javaResource as
                com.pulumi.azurenative.automation.SoftwareUpdateConfigurationByName,
        )
}

/**
 * @see [SoftwareUpdateConfigurationByName].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SoftwareUpdateConfigurationByName].
 */
public suspend fun softwareUpdateConfigurationByName(
    name: String,
    block: suspend SoftwareUpdateConfigurationByNameResourceBuilder.() -> Unit,
):
    SoftwareUpdateConfigurationByName {
    val builder = SoftwareUpdateConfigurationByNameResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SoftwareUpdateConfigurationByName].
 * @param name The _unique_ name of the resulting resource.
 */
public fun softwareUpdateConfigurationByName(name: String): SoftwareUpdateConfigurationByName {
    val builder = SoftwareUpdateConfigurationByNameResourceBuilder()
    builder.name(name)
    return builder.build()
}
