@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Variable].
 */
@PulumiTagMarker
public class VariableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VariableArgs = VariableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VariableArgsBuilder.() -> Unit) {
        val builder = VariableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Variable {
        val builtJavaResource = com.pulumi.azurenative.automation.Variable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Variable(builtJavaResource)
    }
}

/**
 * Definition of the variable.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update a variable
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var variable = new AzureNative.Automation.Variable("variable", new()
 *     {
 *         AutomationAccountName = "sampleAccount9",
 *         Description = "my description",
 *         IsEncrypted = false,
 *         Name = "sampleVariable",
 *         ResourceGroupName = "rg",
 *         Value = "\"ComputerName.domain.com\"",
 *         VariableName = "sampleVariable",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewVariable(ctx, "variable", &automation.VariableArgs{
 * 			AutomationAccountName: pulumi.String("sampleAccount9"),
 * 			Description:           pulumi.String("my description"),
 * 			IsEncrypted:           pulumi.Bool(false),
 * 			Name:                  pulumi.String("sampleVariable"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			Value:                 pulumi.String("\"ComputerName.domain.com\""),
 * 			VariableName:          pulumi.String("sampleVariable"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Variable;
 * import com.pulumi.azurenative.automation.VariableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var variable = new Variable("variable", VariableArgs.builder()
 *             .automationAccountName("sampleAccount9")
 *             .description("my description")
 *             .isEncrypted(false)
 *             .name("sampleVariable")
 *             .resourceGroupName("rg")
 *             .value("\"ComputerName.domain.com\"")
 *             .variableName("sampleVariable")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Variable sampleVariable /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/variables/{variableName}
 * ```
 */
public class Variable internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.Variable,
) : KotlinCustomResource(javaResource, VariableMapper) {
    /**
     * Gets or sets the creation time.
     */
    public val creationTime: Output<String>?
        get() = javaResource.creationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the encrypted flag of the variable.
     */
    public val isEncrypted: Output<Boolean>?
        get() = javaResource.isEncrypted().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the last modified time.
     */
    public val lastModifiedTime: Output<String>?
        get() = javaResource.lastModifiedTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the value of the variable.
     */
    public val `value`: Output<String>?
        get() = javaResource.`value`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object VariableMapper : ResourceMapper<Variable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.Variable::class == javaResource::class

    override fun map(javaResource: Resource): Variable = Variable(
        javaResource as
            com.pulumi.azurenative.automation.Variable,
    )
}

/**
 * @see [Variable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Variable].
 */
public suspend fun variable(name: String, block: suspend VariableResourceBuilder.() -> Unit):
    Variable {
    val builder = VariableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Variable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun variable(name: String): Variable {
    val builder = VariableResourceBuilder()
    builder.name(name)
    return builder.build()
}
