@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.WebhookArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.RunbookAssociationPropertyArgs
import com.pulumi.azurenative.automation.kotlin.inputs.RunbookAssociationPropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the webhook type.
 * Azure REST API version: 2015-10-31. Prior API version in Azure Native 1.x: 2015-10-31.
 * Other available API versions: 2023-05-15-preview.
 * ## Example Usage
 * ### Create or update webhook
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webhook = new AzureNative.Automation.Webhook("webhook", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount33",
 *         ExpiryTime = "2018-03-29T22:18:13.7002872Z",
 *         IsEnabled = true,
 *         Name = "TestWebhook",
 *         ResourceGroupName = "rg",
 *         Runbook = new AzureNative.Automation.Inputs.RunbookAssociationPropertyArgs
 *         {
 *             Name = "TestRunbook",
 *         },
 *         Uri = "<uri>",
 *         WebhookName = "TestWebhook",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewWebhook(ctx, "webhook", &automation.WebhookArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount33"),
 * 			ExpiryTime:            pulumi.String("2018-03-29T22:18:13.7002872Z"),
 * 			IsEnabled:             pulumi.Bool(true),
 * 			Name:                  pulumi.String("TestWebhook"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			Runbook: &automation.RunbookAssociationPropertyArgs{
 * 				Name: pulumi.String("TestRunbook"),
 * 			},
 * 			Uri:         pulumi.String("<uri>"),
 * 			WebhookName: pulumi.String("TestWebhook"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Webhook;
 * import com.pulumi.azurenative.automation.WebhookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webhook = new Webhook("webhook", WebhookArgs.builder()
 *             .automationAccountName("myAutomationAccount33")
 *             .expiryTime("2018-03-29T22:18:13.7002872Z")
 *             .isEnabled(true)
 *             .name("TestWebhook")
 *             .resourceGroupName("rg")
 *             .runbook(Map.of("name", "TestRunbook"))
 *             .uri("<uri>")
 *             .webhookName("TestWebhook")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Webhook TestWebhook /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/webhooks/{webhookName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property expiryTime Gets or sets the expiry time.
 * @property isEnabled Gets or sets the value of the enabled flag of webhook.
 * @property name Gets or sets the name of the webhook.
 * @property parameters Gets or sets the parameters of the job.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property runOn Gets or sets the name of the hybrid worker group the webhook job will run on.
 * @property runbook Gets or sets the runbook.
 * @property uri Gets or sets the uri.
 * @property webhookName The webhook name.
 */
public data class WebhookArgs(
    public val automationAccountName: Output<String>? = null,
    public val expiryTime: Output<String>? = null,
    public val isEnabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runOn: Output<String>? = null,
    public val runbook: Output<RunbookAssociationPropertyArgs>? = null,
    public val uri: Output<String>? = null,
    public val webhookName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.WebhookArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.WebhookArgs =
        com.pulumi.azurenative.automation.WebhookArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .expiryTime(expiryTime?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runOn(runOn?.applyValue({ args0 -> args0 }))
            .runbook(runbook?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .uri(uri?.applyValue({ args0 -> args0 }))
            .webhookName(webhookName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebhookArgs].
 */
@PulumiTagMarker
public class WebhookArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var expiryTime: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var runOn: Output<String>? = null

    private var runbook: Output<RunbookAssociationPropertyArgs>? = null

    private var uri: Output<String>? = null

    private var webhookName: Output<String>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("nqevgotlwcgvgcpi")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Gets or sets the expiry time.
     */
    @JvmName("vymrxeigytiakerp")
    public suspend fun expiryTime(`value`: Output<String>) {
        this.expiryTime = value
    }

    /**
     * @param value Gets or sets the value of the enabled flag of webhook.
     */
    @JvmName("ikrmmcgnpkmqglxg")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Gets or sets the name of the webhook.
     */
    @JvmName("imqkbalvhnnycfwc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the parameters of the job.
     */
    @JvmName("wqtqtiysbykmehuk")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("oudndnbuaikxyylw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the name of the hybrid worker group the webhook job will run on.
     */
    @JvmName("afvrhiexctmdgsof")
    public suspend fun runOn(`value`: Output<String>) {
        this.runOn = value
    }

    /**
     * @param value Gets or sets the runbook.
     */
    @JvmName("rktafginrmdloysf")
    public suspend fun runbook(`value`: Output<RunbookAssociationPropertyArgs>) {
        this.runbook = value
    }

    /**
     * @param value Gets or sets the uri.
     */
    @JvmName("rtwktgclwebnqcdl")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The webhook name.
     */
    @JvmName("rgdodrpxfpyiwfix")
    public suspend fun webhookName(`value`: Output<String>) {
        this.webhookName = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("hqxynyrhqxqtvkvm")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Gets or sets the expiry time.
     */
    @JvmName("lkqxopxwotaqlmgm")
    public suspend fun expiryTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiryTime = mapped
    }

    /**
     * @param value Gets or sets the value of the enabled flag of webhook.
     */
    @JvmName("rqjbcwnhatfiukji")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Gets or sets the name of the webhook.
     */
    @JvmName("yxlfglxqpyslwnne")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the parameters of the job.
     */
    @JvmName("ptjbllxifpaseadk")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Gets or sets the parameters of the job.
     */
    @JvmName("pgwhjtrclsfaoprg")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("neqwqvfyufxjrvlh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the name of the hybrid worker group the webhook job will run on.
     */
    @JvmName("ivshkdjuvfvvnwyq")
    public suspend fun runOn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runOn = mapped
    }

    /**
     * @param value Gets or sets the runbook.
     */
    @JvmName("avwrniiobtistaob")
    public suspend fun runbook(`value`: RunbookAssociationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runbook = mapped
    }

    /**
     * @param argument Gets or sets the runbook.
     */
    @JvmName("wlujxccpqmdunbpe")
    public suspend fun runbook(argument: suspend RunbookAssociationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = RunbookAssociationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.runbook = mapped
    }

    /**
     * @param value Gets or sets the uri.
     */
    @JvmName("qfxlquqytfmuvvdw")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    /**
     * @param value The webhook name.
     */
    @JvmName("ykfkejysnmrrlyff")
    public suspend fun webhookName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookName = mapped
    }

    internal fun build(): WebhookArgs = WebhookArgs(
        automationAccountName = automationAccountName,
        expiryTime = expiryTime,
        isEnabled = isEnabled,
        name = name,
        parameters = parameters,
        resourceGroupName = resourceGroupName,
        runOn = runOn,
        runbook = runbook,
        uri = uri,
        webhookName = webhookName,
    )
}
