@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the type of the runbook.
 */
public enum class RunbookTypeEnum(
    public val javaValue: com.pulumi.azurenative.automation.enums.RunbookTypeEnum,
) : ConvertibleToJava<com.pulumi.azurenative.automation.enums.RunbookTypeEnum> {
    Script(com.pulumi.azurenative.automation.enums.RunbookTypeEnum.Script),
    Graph(com.pulumi.azurenative.automation.enums.RunbookTypeEnum.Graph),
    PowerShellWorkflow(com.pulumi.azurenative.automation.enums.RunbookTypeEnum.PowerShellWorkflow),
    PowerShell(com.pulumi.azurenative.automation.enums.RunbookTypeEnum.PowerShell),
    GraphPowerShellWorkflow(com.pulumi.azurenative.automation.enums.RunbookTypeEnum.GraphPowerShellWorkflow),
    GraphPowerShell(com.pulumi.azurenative.automation.enums.RunbookTypeEnum.GraphPowerShell),
    Python2(com.pulumi.azurenative.automation.enums.RunbookTypeEnum.Python2),
    Python3(com.pulumi.azurenative.automation.enums.RunbookTypeEnum.Python3),
    ;

    override fun toJava(): com.pulumi.azurenative.automation.enums.RunbookTypeEnum = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.enums.RunbookTypeEnum):
            RunbookTypeEnum = RunbookTypeEnum.values().first { it.javaValue == javaType }
    }
}
