@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.ConnectionTypeAssociationPropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The connection type property associated with the entity.
 * @property name Gets or sets the name of the connection type.
 */
public data class ConnectionTypeAssociationPropertyArgs(
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.automation.inputs.ConnectionTypeAssociationPropertyArgs> {
    override fun toJava():
        com.pulumi.azurenative.automation.inputs.ConnectionTypeAssociationPropertyArgs =
        com.pulumi.azurenative.automation.inputs.ConnectionTypeAssociationPropertyArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionTypeAssociationPropertyArgs].
 */
@PulumiTagMarker
public class ConnectionTypeAssociationPropertyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Gets or sets the name of the connection type.
     */
    @JvmName("wbwtnmwswsvfoinx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the name of the connection type.
     */
    @JvmName("gcpalielfqdubjcl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ConnectionTypeAssociationPropertyArgs =
        ConnectionTypeAssociationPropertyArgs(
            name = name,
        )
}
