@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.ContentSourceArgs.builder
import com.pulumi.azurenative.automation.kotlin.enums.ContentSourceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Definition of the content source.
 * @property hash Gets or sets the hash.
 * @property type Gets or sets the content source type.
 * @property value Gets or sets the value of the content. This is based on the content source type.
 * @property version Gets or sets the version of the content.
 */
public data class ContentSourceArgs(
    public val hash: Output<ContentHashArgs>? = null,
    public val type: Output<Either<String, ContentSourceType>>? = null,
    public val `value`: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.ContentSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.ContentSourceArgs =
        com.pulumi.azurenative.automation.inputs.ContentSourceArgs.builder()
            .hash(hash?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentSourceArgs].
 */
@PulumiTagMarker
public class ContentSourceArgsBuilder internal constructor() {
    private var hash: Output<ContentHashArgs>? = null

    private var type: Output<Either<String, ContentSourceType>>? = null

    private var `value`: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Gets or sets the hash.
     */
    @JvmName("lpaqcxuijxyjniog")
    public suspend fun hash(`value`: Output<ContentHashArgs>) {
        this.hash = value
    }

    /**
     * @param value Gets or sets the content source type.
     */
    @JvmName("porisjotioewwvga")
    public suspend fun type(`value`: Output<Either<String, ContentSourceType>>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the value of the content. This is based on the content source type.
     */
    @JvmName("vlohcbshahcibmko")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Gets or sets the version of the content.
     */
    @JvmName("uvjqkwyogrowxxel")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Gets or sets the hash.
     */
    @JvmName("bfrkcipjnygsomka")
    public suspend fun hash(`value`: ContentHashArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hash = mapped
    }

    /**
     * @param argument Gets or sets the hash.
     */
    @JvmName("jubfylqdvsmmytrg")
    public suspend fun hash(argument: suspend ContentHashArgsBuilder.() -> Unit) {
        val toBeMapped = ContentHashArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hash = mapped
    }

    /**
     * @param value Gets or sets the content source type.
     */
    @JvmName("vwsyxphprerqbclm")
    public suspend fun type(`value`: Either<String, ContentSourceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gets or sets the content source type.
     */
    @JvmName("llivvxteaecmyipw")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContentSourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gets or sets the content source type.
     */
    @JvmName("kreakeuplyhvibbr")
    public fun type(`value`: ContentSourceType) {
        val toBeMapped = Either.ofRight<String, ContentSourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gets or sets the value of the content. This is based on the content source type.
     */
    @JvmName("hlrkpjbvcuwekptu")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value Gets or sets the version of the content.
     */
    @JvmName("ipkkxprwwoyjqaat")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ContentSourceArgs = ContentSourceArgs(
        hash = hash,
        type = type,
        `value` = `value`,
        version = version,
    )
}
