@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.FieldDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of the connection fields.
 * @property isEncrypted Gets or sets the isEncrypted flag of the connection field definition.
 * @property isOptional Gets or sets the isOptional flag of the connection field definition.
 * @property type Gets or sets the type of the connection field definition.
 */
public data class FieldDefinitionArgs(
    public val isEncrypted: Output<Boolean>? = null,
    public val isOptional: Output<Boolean>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.FieldDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.FieldDefinitionArgs =
        com.pulumi.azurenative.automation.inputs.FieldDefinitionArgs.builder()
            .isEncrypted(isEncrypted?.applyValue({ args0 -> args0 }))
            .isOptional(isOptional?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FieldDefinitionArgs].
 */
@PulumiTagMarker
public class FieldDefinitionArgsBuilder internal constructor() {
    private var isEncrypted: Output<Boolean>? = null

    private var isOptional: Output<Boolean>? = null

    private var type: Output<String>? = null

    /**
     * @param value Gets or sets the isEncrypted flag of the connection field definition.
     */
    @JvmName("sulgnaxgrjhshyxc")
    public suspend fun isEncrypted(`value`: Output<Boolean>) {
        this.isEncrypted = value
    }

    /**
     * @param value Gets or sets the isOptional flag of the connection field definition.
     */
    @JvmName("ivpavgsksxxkfyox")
    public suspend fun isOptional(`value`: Output<Boolean>) {
        this.isOptional = value
    }

    /**
     * @param value Gets or sets the type of the connection field definition.
     */
    @JvmName("ncoqigamjpsylkrf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the isEncrypted flag of the connection field definition.
     */
    @JvmName("msopqultjqsvauao")
    public suspend fun isEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEncrypted = mapped
    }

    /**
     * @param value Gets or sets the isOptional flag of the connection field definition.
     */
    @JvmName("yesfhxrasqftbgby")
    public suspend fun isOptional(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isOptional = mapped
    }

    /**
     * @param value Gets or sets the type of the connection field definition.
     */
    @JvmName("mygokdfpowkftsgt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FieldDefinitionArgs = FieldDefinitionArgs(
        isEncrypted = isEncrypted,
        isOptional = isOptional,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
