@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetDscNodeConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property nodeConfigurationName The Dsc node configuration name.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class GetDscNodeConfigurationPlainArgs(
    public val automationAccountName: String,
    public val nodeConfigurationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetDscNodeConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetDscNodeConfigurationPlainArgs =
        com.pulumi.azurenative.automation.inputs.GetDscNodeConfigurationPlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .nodeConfigurationName(nodeConfigurationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDscNodeConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetDscNodeConfigurationPlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var nodeConfigurationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("srdebjxiarnskqjl")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value The Dsc node configuration name.
     */
    @JvmName("jqswayatybasvnag")
    public suspend fun nodeConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.nodeConfigurationName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("derbarupteywqnrb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDscNodeConfigurationPlainArgs = GetDscNodeConfigurationPlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        nodeConfigurationName = nodeConfigurationName ?: throw
            PulumiNullFieldException("nodeConfigurationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
