@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetHybridRunbookWorkerGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property hybridRunbookWorkerGroupName The hybrid runbook worker group name
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class GetHybridRunbookWorkerGroupPlainArgs(
    public val automationAccountName: String,
    public val hybridRunbookWorkerGroupName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetHybridRunbookWorkerGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.automation.inputs.GetHybridRunbookWorkerGroupPlainArgs =
        com.pulumi.azurenative.automation.inputs.GetHybridRunbookWorkerGroupPlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .hybridRunbookWorkerGroupName(hybridRunbookWorkerGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHybridRunbookWorkerGroupPlainArgs].
 */
@PulumiTagMarker
public class GetHybridRunbookWorkerGroupPlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var hybridRunbookWorkerGroupName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("ymiwuhseilvfhiwm")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value The hybrid runbook worker group name
     */
    @JvmName("leduqjgimvsugojc")
    public suspend fun hybridRunbookWorkerGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hybridRunbookWorkerGroupName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("jxufbdpkipymyvca")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetHybridRunbookWorkerGroupPlainArgs = GetHybridRunbookWorkerGroupPlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        hybridRunbookWorkerGroupName = hybridRunbookWorkerGroupName ?: throw
            PulumiNullFieldException("hybridRunbookWorkerGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
