@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetPython2PackagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property packageName The python package name.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class GetPython2PackagePlainArgs(
    public val automationAccountName: String,
    public val packageName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetPython2PackagePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetPython2PackagePlainArgs =
        com.pulumi.azurenative.automation.inputs.GetPython2PackagePlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .packageName(packageName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPython2PackagePlainArgs].
 */
@PulumiTagMarker
public class GetPython2PackagePlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var packageName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("mxvphowqqqoedecj")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value The python package name.
     */
    @JvmName("hroidoxfdtvmpowg")
    public suspend fun packageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.packageName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("mhhgtsgbqrcltohm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPython2PackagePlainArgs = GetPython2PackagePlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        packageName = packageName ?: throw PulumiNullFieldException("packageName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
