@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetRuntimeEnvironmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property runtimeEnvironmentName The name of the Runtime Environment.
 */
public data class GetRuntimeEnvironmentPlainArgs(
    public val automationAccountName: String,
    public val resourceGroupName: String,
    public val runtimeEnvironmentName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetRuntimeEnvironmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetRuntimeEnvironmentPlainArgs =
        com.pulumi.azurenative.automation.inputs.GetRuntimeEnvironmentPlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .runtimeEnvironmentName(runtimeEnvironmentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRuntimeEnvironmentPlainArgs].
 */
@PulumiTagMarker
public class GetRuntimeEnvironmentPlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var resourceGroupName: String? = null

    private var runtimeEnvironmentName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("xphmtwghwcgoixps")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("ryyttyliiqsiugly")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Runtime Environment.
     */
    @JvmName("hwsgojixxvxhxlxe")
    public suspend fun runtimeEnvironmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.runtimeEnvironmentName = mapped
    }

    internal fun build(): GetRuntimeEnvironmentPlainArgs = GetRuntimeEnvironmentPlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        runtimeEnvironmentName = runtimeEnvironmentName ?: throw
            PulumiNullFieldException("runtimeEnvironmentName"),
    )
}
