@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetSchedulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property scheduleName The schedule name.
 */
public data class GetSchedulePlainArgs(
    public val automationAccountName: String,
    public val resourceGroupName: String,
    public val scheduleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetSchedulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetSchedulePlainArgs =
        com.pulumi.azurenative.automation.inputs.GetSchedulePlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .scheduleName(scheduleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSchedulePlainArgs].
 */
@PulumiTagMarker
public class GetSchedulePlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var resourceGroupName: String? = null

    private var scheduleName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("vgllpqjoigeuchye")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("rsgfxbgyktgyfdxx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The schedule name.
     */
    @JvmName("jfbyodulnyadputp")
    public suspend fun scheduleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scheduleName = mapped
    }

    internal fun build(): GetSchedulePlainArgs = GetSchedulePlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        scheduleName = scheduleName ?: throw PulumiNullFieldException("scheduleName"),
    )
}
