@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetSourceControlPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property sourceControlName The name of source control.
 */
public data class GetSourceControlPlainArgs(
    public val automationAccountName: String,
    public val resourceGroupName: String,
    public val sourceControlName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetSourceControlPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetSourceControlPlainArgs =
        com.pulumi.azurenative.automation.inputs.GetSourceControlPlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sourceControlName(sourceControlName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSourceControlPlainArgs].
 */
@PulumiTagMarker
public class GetSourceControlPlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var resourceGroupName: String? = null

    private var sourceControlName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("wjplfcgcpnpjwgdo")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("yygkbcyvpfuqlxcx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of source control.
     */
    @JvmName("ydikcuqkwvtayube")
    public suspend fun sourceControlName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sourceControlName = mapped
    }

    internal fun build(): GetSourceControlPlainArgs = GetSourceControlPlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sourceControlName = sourceControlName ?: throw PulumiNullFieldException("sourceControlName"),
    )
}
