@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetWatcherPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property watcherName The watcher name.
 */
public data class GetWatcherPlainArgs(
    public val automationAccountName: String,
    public val resourceGroupName: String,
    public val watcherName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetWatcherPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetWatcherPlainArgs =
        com.pulumi.azurenative.automation.inputs.GetWatcherPlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .watcherName(watcherName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWatcherPlainArgs].
 */
@PulumiTagMarker
public class GetWatcherPlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var resourceGroupName: String? = null

    private var watcherName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("yrmpwdudmvlyqqdf")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("etoacrjyycbotmmy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The watcher name.
     */
    @JvmName("kfpycwlusepxpsjk")
    public suspend fun watcherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.watcherName = mapped
    }

    internal fun build(): GetWatcherPlainArgs = GetWatcherPlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        watcherName = watcherName ?: throw PulumiNullFieldException("watcherName"),
    )
}
