@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetWebhookPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property webhookName The webhook name.
 */
public data class GetWebhookPlainArgs(
    public val automationAccountName: String,
    public val resourceGroupName: String,
    public val webhookName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetWebhookPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetWebhookPlainArgs =
        com.pulumi.azurenative.automation.inputs.GetWebhookPlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .webhookName(webhookName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebhookPlainArgs].
 */
@PulumiTagMarker
public class GetWebhookPlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var resourceGroupName: String? = null

    private var webhookName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("feiaxiaksltvulnj")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("nvnjkubhnxgcwgab")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The webhook name.
     */
    @JvmName("bjbkeyqrqkhykqjl")
    public suspend fun webhookName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.webhookName = mapped
    }

    internal fun build(): GetWebhookPlainArgs = GetWebhookPlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        webhookName = webhookName ?: throw PulumiNullFieldException("webhookName"),
    )
}
