@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.KeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings concerning key vault encryption for a configuration store.
 * @property keyName The name of key used to encrypt data.
 * @property keyVersion The key version of the key used to encrypt data.
 * @property keyvaultUri The URI of the key vault key used to encrypt data.
 */
public data class KeyVaultPropertiesArgs(
    public val keyName: Output<String>? = null,
    public val keyVersion: Output<String>? = null,
    public val keyvaultUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.KeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.KeyVaultPropertiesArgs =
        com.pulumi.azurenative.automation.inputs.KeyVaultPropertiesArgs.builder()
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion?.applyValue({ args0 -> args0 }))
            .keyvaultUri(keyvaultUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultPropertiesArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keyVersion: Output<String>? = null

    private var keyvaultUri: Output<String>? = null

    /**
     * @param value The name of key used to encrypt data.
     */
    @JvmName("xyiqakcjpfqxwgfo")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The key version of the key used to encrypt data.
     */
    @JvmName("wikrghoxdbrtfgxi")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value The URI of the key vault key used to encrypt data.
     */
    @JvmName("vwtbsledobxtdtht")
    public suspend fun keyvaultUri(`value`: Output<String>) {
        this.keyvaultUri = value
    }

    /**
     * @param value The name of key used to encrypt data.
     */
    @JvmName("nflaamptjwrafbkr")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The key version of the key used to encrypt data.
     */
    @JvmName("uyjqhnvbdofgdhjp")
    public suspend fun keyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    /**
     * @param value The URI of the key vault key used to encrypt data.
     */
    @JvmName("cqglksryltlyifqc")
    public suspend fun keyvaultUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyvaultUri = mapped
    }

    internal fun build(): KeyVaultPropertiesArgs = KeyVaultPropertiesArgs(
        keyName = keyName,
        keyVersion = keyVersion,
        keyvaultUri = keyvaultUri,
    )
}
