@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.SoftwareUpdateConfigurationTasksArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Task properties of the software update configuration.
 * @property postTask Post task properties.
 * @property preTask Pre task properties.
 */
public data class SoftwareUpdateConfigurationTasksArgs(
    public val postTask: Output<TaskPropertiesArgs>? = null,
    public val preTask: Output<TaskPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.SoftwareUpdateConfigurationTasksArgs> {
    override fun toJava():
        com.pulumi.azurenative.automation.inputs.SoftwareUpdateConfigurationTasksArgs =
        com.pulumi.azurenative.automation.inputs.SoftwareUpdateConfigurationTasksArgs.builder()
            .postTask(postTask?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preTask(preTask?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SoftwareUpdateConfigurationTasksArgs].
 */
@PulumiTagMarker
public class SoftwareUpdateConfigurationTasksArgsBuilder internal constructor() {
    private var postTask: Output<TaskPropertiesArgs>? = null

    private var preTask: Output<TaskPropertiesArgs>? = null

    /**
     * @param value Post task properties.
     */
    @JvmName("viyogutmjcdcwlua")
    public suspend fun postTask(`value`: Output<TaskPropertiesArgs>) {
        this.postTask = value
    }

    /**
     * @param value Pre task properties.
     */
    @JvmName("imwpeualjvlhnvpj")
    public suspend fun preTask(`value`: Output<TaskPropertiesArgs>) {
        this.preTask = value
    }

    /**
     * @param value Post task properties.
     */
    @JvmName("vwjicsorlkhpyhts")
    public suspend fun postTask(`value`: TaskPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postTask = mapped
    }

    /**
     * @param argument Post task properties.
     */
    @JvmName("trgobtkoetxddkyk")
    public suspend fun postTask(argument: suspend TaskPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TaskPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.postTask = mapped
    }

    /**
     * @param value Pre task properties.
     */
    @JvmName("tmqtgfspxwbiakva")
    public suspend fun preTask(`value`: TaskPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preTask = mapped
    }

    /**
     * @param argument Pre task properties.
     */
    @JvmName("xxyoejgfmxnojmkq")
    public suspend fun preTask(argument: suspend TaskPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TaskPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.preTask = mapped
    }

    internal fun build(): SoftwareUpdateConfigurationTasksArgs = SoftwareUpdateConfigurationTasksArgs(
        postTask = postTask,
        preTask = preTask,
    )
}
