@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.SourceControlSecurityTokenPropertiesArgs.builder
import com.pulumi.azurenative.automation.kotlin.enums.TokenType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessToken The access token.
 * @property refreshToken The refresh token.
 * @property tokenType The token type. Must be either PersonalAccessToken or Oauth.
 */
public data class SourceControlSecurityTokenPropertiesArgs(
    public val accessToken: Output<String>? = null,
    public val refreshToken: Output<String>? = null,
    public val tokenType: Output<Either<String, TokenType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.automation.inputs.SourceControlSecurityTokenPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.automation.inputs.SourceControlSecurityTokenPropertiesArgs =
        com.pulumi.azurenative.automation.inputs.SourceControlSecurityTokenPropertiesArgs.builder()
            .accessToken(accessToken?.applyValue({ args0 -> args0 }))
            .refreshToken(refreshToken?.applyValue({ args0 -> args0 }))
            .tokenType(
                tokenType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SourceControlSecurityTokenPropertiesArgs].
 */
@PulumiTagMarker
public class SourceControlSecurityTokenPropertiesArgsBuilder internal constructor() {
    private var accessToken: Output<String>? = null

    private var refreshToken: Output<String>? = null

    private var tokenType: Output<Either<String, TokenType>>? = null

    /**
     * @param value The access token.
     */
    @JvmName("tckvjuhisnpqmycv")
    public suspend fun accessToken(`value`: Output<String>) {
        this.accessToken = value
    }

    /**
     * @param value The refresh token.
     */
    @JvmName("rgsuhaoqipsfincb")
    public suspend fun refreshToken(`value`: Output<String>) {
        this.refreshToken = value
    }

    /**
     * @param value The token type. Must be either PersonalAccessToken or Oauth.
     */
    @JvmName("kfwgyusbhejgiqva")
    public suspend fun tokenType(`value`: Output<Either<String, TokenType>>) {
        this.tokenType = value
    }

    /**
     * @param value The access token.
     */
    @JvmName("rvcrnmerufcyjydj")
    public suspend fun accessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value The refresh token.
     */
    @JvmName("clxshcrglrfrewad")
    public suspend fun refreshToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    /**
     * @param value The token type. Must be either PersonalAccessToken or Oauth.
     */
    @JvmName("sgcaxjaigqanidqo")
    public suspend fun tokenType(`value`: Either<String, TokenType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenType = mapped
    }

    /**
     * @param value The token type. Must be either PersonalAccessToken or Oauth.
     */
    @JvmName("nrxksopjheeqatud")
    public fun tokenType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TokenType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenType = mapped
    }

    /**
     * @param value The token type. Must be either PersonalAccessToken or Oauth.
     */
    @JvmName("wlablwsiqetmcasm")
    public fun tokenType(`value`: TokenType) {
        val toBeMapped = Either.ofRight<String, TokenType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenType = mapped
    }

    internal fun build(): SourceControlSecurityTokenPropertiesArgs =
        SourceControlSecurityTokenPropertiesArgs(
            accessToken = accessToken,
            refreshToken = refreshToken,
            tokenType = tokenType,
        )
}
