@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Definition of the configuration parameter type.
 * @property defaultValue Gets or sets the default value of parameter.
 * @property isMandatory Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
 * @property position Get or sets the position of the parameter.
 * @property type Gets or sets the type of the parameter.
 */
public data class DscConfigurationParameterResponse(
    public val defaultValue: String? = null,
    public val isMandatory: Boolean? = null,
    public val position: Int? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.DscConfigurationParameterResponse):
            DscConfigurationParameterResponse = DscConfigurationParameterResponse(
            defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
            isMandatory = javaType.isMandatory().map({ args0 -> args0 }).orElse(null),
            position = javaType.position().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
