@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * User identity used for CMK.
 * @property userAssignedIdentity The user identity used for CMK. It will be an ARM resource id in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 */
public data class EncryptionPropertiesResponseIdentity(
    public val userAssignedIdentity: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.EncryptionPropertiesResponseIdentity):
            EncryptionPropertiesResponseIdentity = EncryptionPropertiesResponseIdentity(
            userAssignedIdentity = javaType.userAssignedIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
