@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Definition of the connection.
 * @property connectionType Gets or sets the connectionType of the connection.
 * @property creationTime Gets the creation time.
 * @property description Gets or sets the description.
 * @property fieldDefinitionValues Gets the field definition values of the connection.
 * @property id Fully qualified resource Id for the resource
 * @property lastModifiedTime Gets the last modified time.
 * @property name The name of the resource
 * @property type The type of the resource.
 */
public data class GetConnectionResult(
    public val connectionType: ConnectionTypeAssociationPropertyResponse? = null,
    public val creationTime: String,
    public val description: String? = null,
    public val fieldDefinitionValues: Map<String, String>,
    public val id: String,
    public val lastModifiedTime: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetConnectionResult):
            GetConnectionResult = GetConnectionResult(
            connectionType = javaType.connectionType().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.ConnectionTypeAssociationPropertyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            creationTime = javaType.creationTime(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            fieldDefinitionValues = javaType.fieldDefinitionValues().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            id = javaType.id(),
            lastModifiedTime = javaType.lastModifiedTime(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
