@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Definition of the connection type.
 * @property creationTime Gets the creation time.
 * @property description Gets or sets the description.
 * @property fieldDefinitions Gets the field definitions of the connection type.
 * @property id Gets the id of the resource.
 * @property isGlobal Gets or sets a Boolean value to indicate if the connection type is global.
 * @property lastModifiedTime Gets or sets the last modified time.
 * @property name Gets the name of the connection type.
 * @property type Resource type
 */
public data class GetConnectionTypeResult(
    public val creationTime: String,
    public val description: String? = null,
    public val fieldDefinitions: Map<String, FieldDefinitionResponse>,
    public val id: String,
    public val isGlobal: Boolean? = null,
    public val lastModifiedTime: String? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetConnectionTypeResult):
            GetConnectionTypeResult = GetConnectionTypeResult(
            creationTime = javaType.creationTime(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            fieldDefinitions = javaType.fieldDefinitions().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.automation.kotlin.outputs.FieldDefinitionResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            id = javaType.id(),
            isGlobal = javaType.isGlobal().map({ args0 -> args0 }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
