@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of the credential.
 * @property creationTime Gets the creation time.
 * @property description Gets or sets the description.
 * @property id Fully qualified resource Id for the resource
 * @property lastModifiedTime Gets the last modified time.
 * @property name The name of the resource
 * @property type The type of the resource.
 * @property userName Gets the user name of the credential.
 */
public data class GetCredentialResult(
    public val creationTime: String,
    public val description: String? = null,
    public val id: String,
    public val lastModifiedTime: String,
    public val name: String,
    public val type: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.GetCredentialResult):
            GetCredentialResult = GetCredentialResult(
            creationTime = javaType.creationTime(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastModifiedTime = javaType.lastModifiedTime(),
            name = javaType.name(),
            type = javaType.type(),
            userName = javaType.userName(),
        )
    }
}
