@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Non Azure query for the update configuration.
 * @property functionAlias Log Analytics Saved Search name.
 * @property workspaceId Workspace Id for Log Analytics in which the saved Search is resided.
 */
public data class NonAzureQueryPropertiesResponse(
    public val functionAlias: String? = null,
    public val workspaceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.NonAzureQueryPropertiesResponse):
            NonAzureQueryPropertiesResponse = NonAzureQueryPropertiesResponse(
            functionAlias = javaType.functionAlias().map({ args0 -> args0 }).orElse(null),
            workspaceId = javaType.workspaceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
