@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin

import com.pulumi.azurenative.autonomousdevelopmentplatform.AutonomousdevelopmentplatformFunctions.getAccountPlain
import com.pulumi.azurenative.autonomousdevelopmentplatform.AutonomousdevelopmentplatformFunctions.getDataPoolPlain
import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.inputs.GetDataPoolPlainArgs
import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.inputs.GetDataPoolPlainArgsBuilder
import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs.GetDataPoolResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.outputs.GetDataPoolResult.Companion.toKotlin as getDataPoolResultToKotlin

public object AutonomousdevelopmentplatformFunctions {
    /**
     * Gets the properties of an ADP account
     * Azure REST API version: 2021-11-01-preview.
     * @param argument null
     * @return ADP account
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param accountName The name of the ADP account
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return ADP account
     */
    public suspend fun getAccount(accountName: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;autonomousdevelopmentplatform&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return ADP account
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit):
        GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountResultToKotlin(getAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of a Data Pool
     * Azure REST API version: 2021-11-01-preview.
     * @param argument null
     * @return ADP Data Pool
     */
    public suspend fun getDataPool(argument: GetDataPoolPlainArgs): GetDataPoolResult =
        getDataPoolResultToKotlin(getDataPoolPlain(argument.toJava()).await())

    /**
     * @see [getDataPool].
     * @param accountName The name of the ADP account
     * @param dataPoolName The name of the Data Pool
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return ADP Data Pool
     */
    public suspend fun getDataPool(
        accountName: String,
        dataPoolName: String,
        resourceGroupName: String,
    ): GetDataPoolResult {
        val argument = GetDataPoolPlainArgs(
            accountName = accountName,
            dataPoolName = dataPoolName,
            resourceGroupName = resourceGroupName,
        )
        return getDataPoolResultToKotlin(getDataPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;autonomousdevelopmentplatform&#46;kotlin&#46;inputs&#46;GetDataPoolPlainArgs].
     * @return ADP Data Pool
     */
    public suspend fun getDataPool(argument: suspend GetDataPoolPlainArgsBuilder.() -> Unit):
        GetDataPoolResult {
        val builder = GetDataPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataPoolResultToKotlin(getDataPoolPlain(builtArgument.toJava()).await())
    }
}
