@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.inputs

import com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.GetDataPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the ADP account
 * @property dataPoolName The name of the Data Pool
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDataPoolPlainArgs(
    public val accountName: String,
    public val dataPoolName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.GetDataPoolPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.GetDataPoolPlainArgs =
        com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.GetDataPoolPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .dataPoolName(dataPoolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataPoolPlainArgs].
 */
@PulumiTagMarker
public class GetDataPoolPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var dataPoolName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the ADP account
     */
    @JvmName("wyesbsoucwdleibh")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Data Pool
     */
    @JvmName("bcwwtouhrweinoqx")
    public suspend fun dataPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataPoolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ajpjrplivmornakc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDataPoolPlainArgs = GetDataPoolPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        dataPoolName = dataPoolName ?: throw PulumiNullFieldException("dataPoolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
