@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Authorization].
 */
@PulumiTagMarker
public class AuthorizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuthorizationArgs = AuthorizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuthorizationArgsBuilder.() -> Unit) {
        val builder = AuthorizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Authorization {
        val builtJavaResource = com.pulumi.azurenative.avs.Authorization(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Authorization(builtJavaResource)
    }
}

/**
 * ExpressRoute Circuit Authorization
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-03-20.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### Authorizations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorization = new AzureNative.AVS.Authorization("authorization", new()
 *     {
 *         AuthorizationName = "authorization1",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewAuthorization(ctx, "authorization", &avs.AuthorizationArgs{
 * 			AuthorizationName: pulumi.String("authorization1"),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.Authorization;
 * import com.pulumi.azurenative.avs.AuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorization = new Authorization("authorization", AuthorizationArgs.builder()
 *             .authorizationName("authorization1")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:Authorization authorization1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/authorizations/{authorizationName}
 * ```
 */
public class Authorization internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.Authorization,
) : KotlinCustomResource(javaResource, AuthorizationMapper) {
    /**
     * The ID of the ExpressRoute Circuit Authorization
     */
    public val expressRouteAuthorizationId: Output<String>
        get() = javaResource.expressRouteAuthorizationId().applyValue({ args0 -> args0 })

    /**
     * The key of the ExpressRoute Circuit Authorization
     */
    public val expressRouteAuthorizationKey: Output<String>
        get() = javaResource.expressRouteAuthorizationKey().applyValue({ args0 -> args0 })

    /**
     * The ID of the ExpressRoute Circuit
     */
    public val expressRouteId: Output<String>?
        get() = javaResource.expressRouteId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The state of the  ExpressRoute Circuit Authorization provisioning
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AuthorizationMapper : ResourceMapper<Authorization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.Authorization::class == javaResource::class

    override fun map(javaResource: Resource): Authorization = Authorization(
        javaResource as
            com.pulumi.azurenative.avs.Authorization,
    )
}

/**
 * @see [Authorization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Authorization].
 */
public suspend fun authorization(
    name: String,
    block: suspend AuthorizationResourceBuilder.() -> Unit,
): Authorization {
    val builder = AuthorizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Authorization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun authorization(name: String): Authorization {
    val builder = AuthorizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
