@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CloudLink].
 */
@PulumiTagMarker
public class CloudLinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CloudLinkArgs = CloudLinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CloudLinkArgsBuilder.() -> Unit) {
        val builder = CloudLinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CloudLink {
        val builtJavaResource = com.pulumi.azurenative.avs.CloudLink(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CloudLink(builtJavaResource)
    }
}

/**
 * A cloud link resource
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2021-06-01.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### CloudLinks_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudLink = new AzureNative.AVS.CloudLink("cloudLink", new()
 *     {
 *         CloudLinkName = "cloudLink1",
 *         LinkedCloud = "/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewCloudLink(ctx, "cloudLink", &avs.CloudLinkArgs{
 * 			CloudLinkName:     pulumi.String("cloudLink1"),
 * 			LinkedCloud:       pulumi.String("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2"),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.CloudLink;
 * import com.pulumi.azurenative.avs.CloudLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudLink = new CloudLink("cloudLink", CloudLinkArgs.builder()
 *             .cloudLinkName("cloudLink1")
 *             .linkedCloud("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:CloudLink cloudLink1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/cloudLinks/{cloudLinkName}
 * ```
 */
public class CloudLink internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.CloudLink,
) : KotlinCustomResource(javaResource, CloudLinkMapper) {
    /**
     * Identifier of the other private cloud participating in the link.
     */
    public val linkedCloud: Output<String>?
        get() = javaResource.linkedCloud().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The state of the cloud link.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CloudLinkMapper : ResourceMapper<CloudLink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.CloudLink::class == javaResource::class

    override fun map(javaResource: Resource): CloudLink = CloudLink(
        javaResource as
            com.pulumi.azurenative.avs.CloudLink,
    )
}

/**
 * @see [CloudLink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CloudLink].
 */
public suspend fun cloudLink(name: String, block: suspend CloudLinkResourceBuilder.() -> Unit):
    CloudLink {
    val builder = CloudLinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CloudLink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cloudLink(name: String): CloudLink {
    val builder = CloudLinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
