@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.CloudLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A cloud link resource
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2021-06-01.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### CloudLinks_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudLink = new AzureNative.AVS.CloudLink("cloudLink", new()
 *     {
 *         CloudLinkName = "cloudLink1",
 *         LinkedCloud = "/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewCloudLink(ctx, "cloudLink", &avs.CloudLinkArgs{
 * 			CloudLinkName:     pulumi.String("cloudLink1"),
 * 			LinkedCloud:       pulumi.String("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2"),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.CloudLink;
 * import com.pulumi.azurenative.avs.CloudLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudLink = new CloudLink("cloudLink", CloudLinkArgs.builder()
 *             .cloudLinkName("cloudLink1")
 *             .linkedCloud("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.AVS/privateClouds/cloud2")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:CloudLink cloudLink1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/cloudLinks/{cloudLinkName}
 * ```
 * @property cloudLinkName Name of the cloud link resource
 * @property linkedCloud Identifier of the other private cloud participating in the link.
 * @property privateCloudName The name of the private cloud.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class CloudLinkArgs(
    public val cloudLinkName: Output<String>? = null,
    public val linkedCloud: Output<String>? = null,
    public val privateCloudName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.CloudLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.CloudLinkArgs =
        com.pulumi.azurenative.avs.CloudLinkArgs.builder()
            .cloudLinkName(cloudLinkName?.applyValue({ args0 -> args0 }))
            .linkedCloud(linkedCloud?.applyValue({ args0 -> args0 }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CloudLinkArgs].
 */
@PulumiTagMarker
public class CloudLinkArgsBuilder internal constructor() {
    private var cloudLinkName: Output<String>? = null

    private var linkedCloud: Output<String>? = null

    private var privateCloudName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the cloud link resource
     */
    @JvmName("gnesdporttjnilpy")
    public suspend fun cloudLinkName(`value`: Output<String>) {
        this.cloudLinkName = value
    }

    /**
     * @param value Identifier of the other private cloud participating in the link.
     */
    @JvmName("amwdfjgpsabqcbmx")
    public suspend fun linkedCloud(`value`: Output<String>) {
        this.linkedCloud = value
    }

    /**
     * @param value The name of the private cloud.
     */
    @JvmName("masbyvibruvjlfua")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qwigawyviihkbqwd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the cloud link resource
     */
    @JvmName("avscktrcinywxvak")
    public suspend fun cloudLinkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudLinkName = mapped
    }

    /**
     * @param value Identifier of the other private cloud participating in the link.
     */
    @JvmName("lmgsinyrowyoqytu")
    public suspend fun linkedCloud(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedCloud = mapped
    }

    /**
     * @param value The name of the private cloud.
     */
    @JvmName("frtldeqgflupxjji")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vjblmivfphsyaidy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): CloudLinkArgs = CloudLinkArgs(
        cloudLinkName = cloudLinkName,
        linkedCloud = linkedCloud,
        privateCloudName = privateCloudName,
        resourceGroupName = resourceGroupName,
    )
}
