@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.kotlin.outputs.DiskPoolVolumeResponse
import com.pulumi.azurenative.avs.kotlin.outputs.NetAppVolumeResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.avs.kotlin.outputs.DiskPoolVolumeResponse.Companion.toKotlin as diskPoolVolumeResponseToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.NetAppVolumeResponse.Companion.toKotlin as netAppVolumeResponseToKotlin

/**
 * Builder for [Datastore].
 */
@PulumiTagMarker
public class DatastoreResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatastoreArgs = DatastoreArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatastoreArgsBuilder.() -> Unit) {
        val builder = DatastoreArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Datastore {
        val builtJavaResource = com.pulumi.azurenative.avs.Datastore(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Datastore(builtJavaResource)
    }
}

/**
 * A datastore resource
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2021-01-01-preview.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### Datastores_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var datastore = new AzureNative.AVS.Datastore("datastore", new()
 *     {
 *         ClusterName = "cluster1",
 *         DatastoreName = "datastore1",
 *         NetAppVolume = new AzureNative.AVS.Inputs.NetAppVolumeArgs
 *         {
 *             Id = "/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/ResourceGroup1/providers/Microsoft.NetApp/netAppAccounts/NetAppAccount1/capacityPools/CapacityPool1/volumes/NFSVol1",
 *         },
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewDatastore(ctx, "datastore", &avs.DatastoreArgs{
 * 			ClusterName:   pulumi.String("cluster1"),
 * 			DatastoreName: pulumi.String("datastore1"),
 * 			NetAppVolume: &avs.NetAppVolumeArgs{
 * 				Id: pulumi.String("/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/ResourceGroup1/providers/Microsoft.NetApp/netAppAccounts/NetAppAccount1/capacityPools/CapacityPool1/volumes/NFSVol1"),
 * 			},
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.Datastore;
 * import com.pulumi.azurenative.avs.DatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var datastore = new Datastore("datastore", DatastoreArgs.builder()
 *             .clusterName("cluster1")
 *             .datastoreName("datastore1")
 *             .netAppVolume(Map.of("id", "/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/ResourceGroup1/providers/Microsoft.NetApp/netAppAccounts/NetAppAccount1/capacityPools/CapacityPool1/volumes/NFSVol1"))
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:Datastore datastore1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/clusters/{clusterName}/datastores/{datastoreName}
 * ```
 */
public class Datastore internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.Datastore,
) : KotlinCustomResource(javaResource, DatastoreMapper) {
    /**
     * An iSCSI volume
     */
    public val diskPoolVolume: Output<DiskPoolVolumeResponse>?
        get() = javaResource.diskPoolVolume().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> diskPoolVolumeResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * An Azure NetApp Files volume
     */
    public val netAppVolume: Output<NetAppVolumeResponse>?
        get() = javaResource.netAppVolume().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    netAppVolumeResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The state of the datastore provisioning
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The operational status of the datastore
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DatastoreMapper : ResourceMapper<Datastore> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.Datastore::class == javaResource::class

    override fun map(javaResource: Resource): Datastore = Datastore(
        javaResource as
            com.pulumi.azurenative.avs.Datastore,
    )
}

/**
 * @see [Datastore].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Datastore].
 */
public suspend fun datastore(name: String, block: suspend DatastoreResourceBuilder.() -> Unit):
    Datastore {
    val builder = DatastoreResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Datastore].
 * @param name The _unique_ name of the resulting resource.
 */
public fun datastore(name: String): Datastore {
    val builder = DatastoreResourceBuilder()
    builder.name(name)
    return builder.build()
}
