@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.DatastoreArgs.builder
import com.pulumi.azurenative.avs.kotlin.inputs.DiskPoolVolumeArgs
import com.pulumi.azurenative.avs.kotlin.inputs.DiskPoolVolumeArgsBuilder
import com.pulumi.azurenative.avs.kotlin.inputs.NetAppVolumeArgs
import com.pulumi.azurenative.avs.kotlin.inputs.NetAppVolumeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A datastore resource
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2021-01-01-preview.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### Datastores_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var datastore = new AzureNative.AVS.Datastore("datastore", new()
 *     {
 *         ClusterName = "cluster1",
 *         DatastoreName = "datastore1",
 *         NetAppVolume = new AzureNative.AVS.Inputs.NetAppVolumeArgs
 *         {
 *             Id = "/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/ResourceGroup1/providers/Microsoft.NetApp/netAppAccounts/NetAppAccount1/capacityPools/CapacityPool1/volumes/NFSVol1",
 *         },
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewDatastore(ctx, "datastore", &avs.DatastoreArgs{
 * 			ClusterName:   pulumi.String("cluster1"),
 * 			DatastoreName: pulumi.String("datastore1"),
 * 			NetAppVolume: &avs.NetAppVolumeArgs{
 * 				Id: pulumi.String("/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/ResourceGroup1/providers/Microsoft.NetApp/netAppAccounts/NetAppAccount1/capacityPools/CapacityPool1/volumes/NFSVol1"),
 * 			},
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.Datastore;
 * import com.pulumi.azurenative.avs.DatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var datastore = new Datastore("datastore", DatastoreArgs.builder()
 *             .clusterName("cluster1")
 *             .datastoreName("datastore1")
 *             .netAppVolume(Map.of("id", "/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/ResourceGroup1/providers/Microsoft.NetApp/netAppAccounts/NetAppAccount1/capacityPools/CapacityPool1/volumes/NFSVol1"))
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:Datastore datastore1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/clusters/{clusterName}/datastores/{datastoreName}
 * ```
 * @property clusterName Name of the cluster in the private cloud
 * @property datastoreName Name of the datastore in the private cloud cluster
 * @property diskPoolVolume An iSCSI volume
 * @property netAppVolume An Azure NetApp Files volume
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class DatastoreArgs(
    public val clusterName: Output<String>? = null,
    public val datastoreName: Output<String>? = null,
    public val diskPoolVolume: Output<DiskPoolVolumeArgs>? = null,
    public val netAppVolume: Output<NetAppVolumeArgs>? = null,
    public val privateCloudName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.DatastoreArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.DatastoreArgs =
        com.pulumi.azurenative.avs.DatastoreArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .datastoreName(datastoreName?.applyValue({ args0 -> args0 }))
            .diskPoolVolume(diskPoolVolume?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .netAppVolume(netAppVolume?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatastoreArgs].
 */
@PulumiTagMarker
public class DatastoreArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var datastoreName: Output<String>? = null

    private var diskPoolVolume: Output<DiskPoolVolumeArgs>? = null

    private var netAppVolume: Output<NetAppVolumeArgs>? = null

    private var privateCloudName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the cluster in the private cloud
     */
    @JvmName("xrrkxamnfikkagwm")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Name of the datastore in the private cloud cluster
     */
    @JvmName("ctllvcdvumgoounm")
    public suspend fun datastoreName(`value`: Output<String>) {
        this.datastoreName = value
    }

    /**
     * @param value An iSCSI volume
     */
    @JvmName("qfobjtnihcalepnl")
    public suspend fun diskPoolVolume(`value`: Output<DiskPoolVolumeArgs>) {
        this.diskPoolVolume = value
    }

    /**
     * @param value An Azure NetApp Files volume
     */
    @JvmName("beihifrsydqvdfub")
    public suspend fun netAppVolume(`value`: Output<NetAppVolumeArgs>) {
        this.netAppVolume = value
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("qrlouwmwwvyaulfk")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lxwbfswwmbisjxxw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the cluster in the private cloud
     */
    @JvmName("mgthhpyupbbenhkr")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Name of the datastore in the private cloud cluster
     */
    @JvmName("wowptggysppmmovl")
    public suspend fun datastoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datastoreName = mapped
    }

    /**
     * @param value An iSCSI volume
     */
    @JvmName("whfoctodanmyinyj")
    public suspend fun diskPoolVolume(`value`: DiskPoolVolumeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskPoolVolume = mapped
    }

    /**
     * @param argument An iSCSI volume
     */
    @JvmName("qcmtrtuqsgtoyjwc")
    public suspend fun diskPoolVolume(argument: suspend DiskPoolVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = DiskPoolVolumeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskPoolVolume = mapped
    }

    /**
     * @param value An Azure NetApp Files volume
     */
    @JvmName("stfyfrsdqjwqnyhx")
    public suspend fun netAppVolume(`value`: NetAppVolumeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netAppVolume = mapped
    }

    /**
     * @param argument An Azure NetApp Files volume
     */
    @JvmName("bqgasbeuwqnjbxcg")
    public suspend fun netAppVolume(argument: suspend NetAppVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = NetAppVolumeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.netAppVolume = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("edekbccqrcvblptw")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("loumnweyfrppwwvg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DatastoreArgs = DatastoreArgs(
        clusterName = clusterName,
        datastoreName = datastoreName,
        diskPoolVolume = diskPoolVolume,
        netAppVolume = netAppVolume,
        privateCloudName = privateCloudName,
        resourceGroupName = resourceGroupName,
    )
}
