@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.GlobalReachConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A global reach connection resource
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### GlobalReachConnections_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var globalReachConnection = new AzureNative.AVS.GlobalReachConnection("globalReachConnection", new()
 *     {
 *         AuthorizationKey = "01010101-0101-0101-0101-010101010101",
 *         GlobalReachConnectionName = "connection1",
 *         PeerExpressRouteCircuit = "/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.Network/expressRouteCircuits/mypeer",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewGlobalReachConnection(ctx, "globalReachConnection", &avs.GlobalReachConnectionArgs{
 * 			AuthorizationKey:          pulumi.String("01010101-0101-0101-0101-010101010101"),
 * 			GlobalReachConnectionName: pulumi.String("connection1"),
 * 			PeerExpressRouteCircuit:   pulumi.String("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.Network/expressRouteCircuits/mypeer"),
 * 			PrivateCloudName:          pulumi.String("cloud1"),
 * 			ResourceGroupName:         pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.GlobalReachConnection;
 * import com.pulumi.azurenative.avs.GlobalReachConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var globalReachConnection = new GlobalReachConnection("globalReachConnection", GlobalReachConnectionArgs.builder()
 *             .authorizationKey("01010101-0101-0101-0101-010101010101")
 *             .globalReachConnectionName("connection1")
 *             .peerExpressRouteCircuit("/subscriptions/12341234-1234-1234-1234-123412341234/resourceGroups/mygroup/providers/Microsoft.Network/expressRouteCircuits/mypeer")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:GlobalReachConnection connection1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/globalReachConnections/{globalReachConnectionName}
 * ```
 * @property authorizationKey Authorization key from the peer express route used for the global reach connection
 * @property expressRouteId The ID of the Private Cloud's ExpressRoute Circuit that is participating in the global reach connection
 * @property globalReachConnectionName Name of the global reach connection in the private cloud
 * @property peerExpressRouteCircuit Identifier of the ExpressRoute Circuit to peer with in the global reach connection
 * @property privateCloudName The name of the private cloud.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GlobalReachConnectionArgs(
    public val authorizationKey: Output<String>? = null,
    public val expressRouteId: Output<String>? = null,
    public val globalReachConnectionName: Output<String>? = null,
    public val peerExpressRouteCircuit: Output<String>? = null,
    public val privateCloudName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.GlobalReachConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.GlobalReachConnectionArgs =
        com.pulumi.azurenative.avs.GlobalReachConnectionArgs.builder()
            .authorizationKey(authorizationKey?.applyValue({ args0 -> args0 }))
            .expressRouteId(expressRouteId?.applyValue({ args0 -> args0 }))
            .globalReachConnectionName(globalReachConnectionName?.applyValue({ args0 -> args0 }))
            .peerExpressRouteCircuit(peerExpressRouteCircuit?.applyValue({ args0 -> args0 }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GlobalReachConnectionArgs].
 */
@PulumiTagMarker
public class GlobalReachConnectionArgsBuilder internal constructor() {
    private var authorizationKey: Output<String>? = null

    private var expressRouteId: Output<String>? = null

    private var globalReachConnectionName: Output<String>? = null

    private var peerExpressRouteCircuit: Output<String>? = null

    private var privateCloudName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Authorization key from the peer express route used for the global reach connection
     */
    @JvmName("gyguwtubovpjpbxh")
    public suspend fun authorizationKey(`value`: Output<String>) {
        this.authorizationKey = value
    }

    /**
     * @param value The ID of the Private Cloud's ExpressRoute Circuit that is participating in the global reach connection
     */
    @JvmName("hiokakwnrgqxbcpb")
    public suspend fun expressRouteId(`value`: Output<String>) {
        this.expressRouteId = value
    }

    /**
     * @param value Name of the global reach connection in the private cloud
     */
    @JvmName("idapsynyktkrkrdx")
    public suspend fun globalReachConnectionName(`value`: Output<String>) {
        this.globalReachConnectionName = value
    }

    /**
     * @param value Identifier of the ExpressRoute Circuit to peer with in the global reach connection
     */
    @JvmName("qtxgkmkvytbouqqi")
    public suspend fun peerExpressRouteCircuit(`value`: Output<String>) {
        this.peerExpressRouteCircuit = value
    }

    /**
     * @param value The name of the private cloud.
     */
    @JvmName("weitgcxqjsqyenhd")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vibljrmhkrrddqyx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Authorization key from the peer express route used for the global reach connection
     */
    @JvmName("ntpnbmasmjrfeakp")
    public suspend fun authorizationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationKey = mapped
    }

    /**
     * @param value The ID of the Private Cloud's ExpressRoute Circuit that is participating in the global reach connection
     */
    @JvmName("xivjwrmmgxrjeqkn")
    public suspend fun expressRouteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRouteId = mapped
    }

    /**
     * @param value Name of the global reach connection in the private cloud
     */
    @JvmName("oxwnolpqeygirfek")
    public suspend fun globalReachConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalReachConnectionName = mapped
    }

    /**
     * @param value Identifier of the ExpressRoute Circuit to peer with in the global reach connection
     */
    @JvmName("xjcefkcwnufriirp")
    public suspend fun peerExpressRouteCircuit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerExpressRouteCircuit = mapped
    }

    /**
     * @param value The name of the private cloud.
     */
    @JvmName("abnvdmfwhhnjnqps")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vaaykgurrlnlqkqw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): GlobalReachConnectionArgs = GlobalReachConnectionArgs(
        authorizationKey = authorizationKey,
        expressRouteId = expressRouteId,
        globalReachConnectionName = globalReachConnectionName,
        peerExpressRouteCircuit = peerExpressRouteCircuit,
        privateCloudName = privateCloudName,
        resourceGroupName = resourceGroupName,
    )
}
