@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.PlacementPolicyArgs.builder
import com.pulumi.azurenative.avs.kotlin.inputs.VmHostPlacementPolicyPropertiesArgs
import com.pulumi.azurenative.avs.kotlin.inputs.VmVmPlacementPolicyPropertiesArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A vSphere Distributed Resource Scheduler (DRS) placement policy
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2021-12-01.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### PlacementPolicies_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var placementPolicy = new AzureNative.AVS.PlacementPolicy("placementPolicy", new()
 *     {
 *         ClusterName = "cluster1",
 *         PlacementPolicyName = "policy1",
 *         PrivateCloudName = "cloud1",
 *         Properties = new AzureNative.AVS.Inputs.VmHostPlacementPolicyPropertiesArgs
 *         {
 *             AffinityStrength = "Must",
 *             AffinityType = "AntiAffinity",
 *             AzureHybridBenefitType = "SqlHost",
 *             HostMembers = new[]
 *             {
 *                 "fakehost22.nyc1.kubernetes.center",
 *                 "fakehost23.nyc1.kubernetes.center",
 *                 "fakehost24.nyc1.kubernetes.center",
 *             },
 *             Type = "VmHost",
 *             VmMembers = new[]
 *             {
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/clusters/cluster1/virtualMachines/vm-128",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/clusters/cluster1/virtualMachines/vm-256",
 *             },
 *         },
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewPlacementPolicy(ctx, "placementPolicy", &avs.PlacementPolicyArgs{
 * 			ClusterName:         pulumi.String("cluster1"),
 * 			PlacementPolicyName: pulumi.String("policy1"),
 * 			PrivateCloudName:    pulumi.String("cloud1"),
 * 			Properties: avs.VmHostPlacementPolicyProperties{
 * 				AffinityStrength:       "Must",
 * 				AffinityType:           "AntiAffinity",
 * 				AzureHybridBenefitType: "SqlHost",
 * 				HostMembers: []string{
 * 					"fakehost22.nyc1.kubernetes.center",
 * 					"fakehost23.nyc1.kubernetes.center",
 * 					"fakehost24.nyc1.kubernetes.center",
 * 				},
 * 				Type: "VmHost",
 * 				VmMembers: []string{
 * 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/clusters/cluster1/virtualMachines/vm-128",
 * 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/clusters/cluster1/virtualMachines/vm-256",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.PlacementPolicy;
 * import com.pulumi.azurenative.avs.PlacementPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var placementPolicy = new PlacementPolicy("placementPolicy", PlacementPolicyArgs.builder()
 *             .clusterName("cluster1")
 *             .placementPolicyName("policy1")
 *             .privateCloudName("cloud1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("affinityStrength", "Must"),
 *                 Map.entry("affinityType", "AntiAffinity"),
 *                 Map.entry("azureHybridBenefitType", "SqlHost"),
 *                 Map.entry("hostMembers",
 *                     "fakehost22.nyc1.kubernetes.center",
 *                     "fakehost23.nyc1.kubernetes.center",
 *                     "fakehost24.nyc1.kubernetes.center"),
 *                 Map.entry("type", "VmHost"),
 *                 Map.entry("vmMembers",
 *                     "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/clusters/cluster1/virtualMachines/vm-128",
 *                     "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/clusters/cluster1/virtualMachines/vm-256")
 *             ))
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:PlacementPolicy policy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/clusters/{clusterName}/placementPolicies/{placementPolicyName}
 * ```
 * @property clusterName Name of the cluster in the private cloud
 * @property placementPolicyName Name of the VMware vSphere Distributed Resource Scheduler (DRS) placement policy
 * @property privateCloudName Name of the private cloud
 * @property properties placement policy properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class PlacementPolicyArgs(
    public val clusterName: Output<String>? = null,
    public val placementPolicyName: Output<String>? = null,
    public val privateCloudName: Output<String>? = null,
    public val properties:
    Output<Either<VmHostPlacementPolicyPropertiesArgs, VmVmPlacementPolicyPropertiesArgs>>? =
        null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.PlacementPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.PlacementPolicyArgs =
        com.pulumi.azurenative.avs.PlacementPolicyArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .placementPolicyName(placementPolicyName?.applyValue({ args0 -> args0 }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlacementPolicyArgs].
 */
@PulumiTagMarker
public class PlacementPolicyArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var placementPolicyName: Output<String>? = null

    private var privateCloudName: Output<String>? = null

    private var properties:
        Output<Either<VmHostPlacementPolicyPropertiesArgs, VmVmPlacementPolicyPropertiesArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the cluster in the private cloud
     */
    @JvmName("unsgavebbotkcaxp")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Name of the VMware vSphere Distributed Resource Scheduler (DRS) placement policy
     */
    @JvmName("nanrbesandrrctxv")
    public suspend fun placementPolicyName(`value`: Output<String>) {
        this.placementPolicyName = value
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("cedpbhytrfkwsnfw")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value placement policy properties
     */
    @JvmName("otaefspisbsofkkt")
    public suspend
    fun properties(`value`: Output<Either<VmHostPlacementPolicyPropertiesArgs, VmVmPlacementPolicyPropertiesArgs>>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vptyemwjqqgldick")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the cluster in the private cloud
     */
    @JvmName("yyfgfjtpiblspwxa")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Name of the VMware vSphere Distributed Resource Scheduler (DRS) placement policy
     */
    @JvmName("cnxekqbuvguvgsay")
    public suspend fun placementPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementPolicyName = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("glboeqkmgtdornjf")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value placement policy properties
     */
    @JvmName("nuwulylmradmrrdi")
    public suspend
    fun properties(`value`: Either<VmHostPlacementPolicyPropertiesArgs, VmVmPlacementPolicyPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value placement policy properties
     */
    @JvmName("qmlnjryfjfwwjkla")
    public fun properties(`value`: VmHostPlacementPolicyPropertiesArgs) {
        val toBeMapped = Either.ofLeft<VmHostPlacementPolicyPropertiesArgs,
            VmVmPlacementPolicyPropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value placement policy properties
     */
    @JvmName("akwnclfebhncvltk")
    public fun properties(`value`: VmVmPlacementPolicyPropertiesArgs) {
        val toBeMapped = Either.ofRight<VmHostPlacementPolicyPropertiesArgs,
            VmVmPlacementPolicyPropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jxptxteqipkelyau")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PlacementPolicyArgs = PlacementPolicyArgs(
        clusterName = clusterName,
        placementPolicyName = placementPolicyName,
        privateCloudName = privateCloudName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
