@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ScriptExecution].
 */
@PulumiTagMarker
public class ScriptExecutionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScriptExecutionArgs = ScriptExecutionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScriptExecutionArgsBuilder.() -> Unit) {
        val builder = ScriptExecutionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ScriptExecution {
        val builtJavaResource = com.pulumi.azurenative.avs.ScriptExecution(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ScriptExecution(builtJavaResource)
    }
}

/**
 * An instance of a script executed by a user - custom or AVS
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2021-06-01.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### ScriptExecutions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scriptExecution = new AzureNative.AVS.ScriptExecution("scriptExecution", new()
 *     {
 *         HiddenParameters = new[]
 *         {
 *             new AzureNative.AVS.Inputs.ScriptSecureStringExecutionParameterArgs
 *             {
 *                 Name = "Password",
 *                 SecureValue = "PlaceholderPassword",
 *                 Type = "SecureValue",
 *             },
 *         },
 *         Parameters = new[]
 *         {
 *             new AzureNative.AVS.Inputs.ScriptStringExecutionParameterArgs
 *             {
 *                 Name = "DomainName",
 *                 Type = "Value",
 *                 Value = "placeholderDomain.local",
 *             },
 *             new AzureNative.AVS.Inputs.ScriptStringExecutionParameterArgs
 *             {
 *                 Name = "BaseUserDN",
 *                 Type = "Value",
 *                 Value = "DC=placeholder, DC=placeholder",
 *             },
 *         },
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Retention = "P0Y0M60DT0H60M60S",
 *         ScriptCmdletId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptPackages/AVS.PowerCommands@1.0.0/scriptCmdlets/New-SsoExternalIdentitySource",
 *         ScriptExecutionName = "addSsoServer",
 *         Timeout = "P0Y0M0DT0H60M60S",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewScriptExecution(ctx, "scriptExecution", &avs.ScriptExecutionArgs{
 * 			HiddenParameters: pulumi.Array{
 * 				avs.ScriptSecureStringExecutionParameter{
 * 					Name:        "Password",
 * 					SecureValue: "PlaceholderPassword",
 * 					Type:        "SecureValue",
 * 				},
 * 			},
 * 			Parameters: pulumi.Array{
 * 				avs.ScriptStringExecutionParameter{
 * 					Name:  "DomainName",
 * 					Type:  "Value",
 * 					Value: "placeholderDomain.local",
 * 				},
 * 				avs.ScriptStringExecutionParameter{
 * 					Name:  "BaseUserDN",
 * 					Type:  "Value",
 * 					Value: "DC=placeholder, DC=placeholder",
 * 				},
 * 			},
 * 			PrivateCloudName:    pulumi.String("cloud1"),
 * 			ResourceGroupName:   pulumi.String("group1"),
 * 			Retention:           pulumi.String("P0Y0M60DT0H60M60S"),
 * 			ScriptCmdletId:      pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptPackages/AVS.PowerCommands@1.0.0/scriptCmdlets/New-SsoExternalIdentitySource"),
 * 			ScriptExecutionName: pulumi.String("addSsoServer"),
 * 			Timeout:             pulumi.String("P0Y0M0DT0H60M60S"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.ScriptExecution;
 * import com.pulumi.azurenative.avs.ScriptExecutionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scriptExecution = new ScriptExecution("scriptExecution", ScriptExecutionArgs.builder()
 *             .hiddenParameters(Map.ofEntries(
 *                 Map.entry("name", "Password"),
 *                 Map.entry("secureValue", "PlaceholderPassword"),
 *                 Map.entry("type", "SecureValue")
 *             ))
 *             .parameters(
 *                 Map.ofEntries(
 *                     Map.entry("name", "DomainName"),
 *                     Map.entry("type", "Value"),
 *                     Map.entry("value", "placeholderDomain.local")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "BaseUserDN"),
 *                     Map.entry("type", "Value"),
 *                     Map.entry("value", "DC=placeholder, DC=placeholder")
 *                 ))
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .retention("P0Y0M60DT0H60M60S")
 *             .scriptCmdletId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptPackages/AVS.PowerCommands@1.0.0/scriptCmdlets/New-SsoExternalIdentitySource")
 *             .scriptExecutionName("addSsoServer")
 *             .timeout("P0Y0M0DT0H60M60S")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:ScriptExecution addSsoServer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/scriptExecutions/{scriptExecutionName}
 * ```
 */
public class ScriptExecution internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.ScriptExecution,
) : KotlinCustomResource(javaResource, ScriptExecutionMapper) {
    /**
     * Standard error output stream from the powershell execution
     */
    public val errors: Output<List<String>>
        get() = javaResource.errors().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Error message if the script was able to run, but if the script itself had errors or powershell threw an exception
     */
    public val failureReason: Output<String>?
        get() = javaResource.failureReason().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time the script execution was finished
     */
    public val finishedAt: Output<String>
        get() = javaResource.finishedAt().applyValue({ args0 -> args0 })

    /**
     * Parameters that will be hidden/not visible to ARM, such as passwords and credentials
     */
    public val hiddenParameters: Output<List<Any>>?
        get() = javaResource.hiddenParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Standard information out stream from the powershell execution
     */
    public val information: Output<List<String>>
        get() = javaResource.information().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * User-defined dictionary.
     */
    public val namedOutputs: Output<Map<String, Any>>?
        get() = javaResource.namedOutputs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Standard output stream from the powershell execution
     */
    public val output: Output<List<String>>?
        get() = javaResource.output().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Parameters the script will accept
     */
    public val parameters: Output<List<Any>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The state of the script execution resource
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Time to live for the resource. If not provided, will be available for 60 days
     */
    public val retention: Output<String>?
        get() = javaResource.retention().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A reference to the script cmdlet resource if user is running a AVS script
     */
    public val scriptCmdletId: Output<String>?
        get() = javaResource.scriptCmdletId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time the script execution was started
     */
    public val startedAt: Output<String>
        get() = javaResource.startedAt().applyValue({ args0 -> args0 })

    /**
     * Time the script execution was submitted
     */
    public val submittedAt: Output<String>
        get() = javaResource.submittedAt().applyValue({ args0 -> args0 })

    /**
     * Time limit for execution
     */
    public val timeout: Output<String>
        get() = javaResource.timeout().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Standard warning out stream from the powershell execution
     */
    public val warnings: Output<List<String>>
        get() = javaResource.warnings().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ScriptExecutionMapper : ResourceMapper<ScriptExecution> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.ScriptExecution::class == javaResource::class

    override fun map(javaResource: Resource): ScriptExecution = ScriptExecution(
        javaResource as
            com.pulumi.azurenative.avs.ScriptExecution,
    )
}

/**
 * @see [ScriptExecution].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScriptExecution].
 */
public suspend fun scriptExecution(
    name: String,
    block: suspend ScriptExecutionResourceBuilder.() -> Unit,
): ScriptExecution {
    val builder = ScriptExecutionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScriptExecution].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scriptExecution(name: String): ScriptExecution {
    val builder = ScriptExecutionResourceBuilder()
    builder.name(name)
    return builder.build()
}
