@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.WorkloadNetworkDhcpArgs.builder
import com.pulumi.azurenative.avs.kotlin.inputs.WorkloadNetworkDhcpRelayArgs
import com.pulumi.azurenative.avs.kotlin.inputs.WorkloadNetworkDhcpServerArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * NSX DHCP
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2021-01-01-preview, 2023-03-01.
 * ## Example Usage
 * ### WorkloadNetworks_CreateDhcp
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadNetworkDhcp = new AzureNative.AVS.WorkloadNetworkDhcp("workloadNetworkDhcp", new()
 *     {
 *         DhcpId = "dhcp1",
 *         PrivateCloudName = "cloud1",
 *         Properties = new AzureNative.AVS.Inputs.WorkloadNetworkDhcpServerArgs
 *         {
 *             DhcpType = "SERVER",
 *             DisplayName = "dhcpConfigurations1",
 *             LeaseTime = 86400,
 *             Revision = 1,
 *             ServerAddress = "40.1.5.1/24",
 *         },
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewWorkloadNetworkDhcp(ctx, "workloadNetworkDhcp", &avs.WorkloadNetworkDhcpArgs{
 * 			DhcpId:           pulumi.String("dhcp1"),
 * 			PrivateCloudName: pulumi.String("cloud1"),
 * 			Properties: avs.WorkloadNetworkDhcpServer{
 * 				DhcpType:      "SERVER",
 * 				DisplayName:   "dhcpConfigurations1",
 * 				LeaseTime:     86400,
 * 				Revision:      1,
 * 				ServerAddress: "40.1.5.1/24",
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.WorkloadNetworkDhcp;
 * import com.pulumi.azurenative.avs.WorkloadNetworkDhcpArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadNetworkDhcp = new WorkloadNetworkDhcp("workloadNetworkDhcp", WorkloadNetworkDhcpArgs.builder()
 *             .dhcpId("dhcp1")
 *             .privateCloudName("cloud1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("dhcpType", "SERVER"),
 *                 Map.entry("displayName", "dhcpConfigurations1"),
 *                 Map.entry("leaseTime", 86400),
 *                 Map.entry("revision", 1),
 *                 Map.entry("serverAddress", "40.1.5.1/24")
 *             ))
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:WorkloadNetworkDhcp dhcp1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dhcpConfigurations/{dhcpId}
 * ```
 * @property dhcpId NSX DHCP identifier. Generally the same as the DHCP display name
 * @property privateCloudName Name of the private cloud
 * @property properties DHCP properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class WorkloadNetworkDhcpArgs(
    public val dhcpId: Output<String>? = null,
    public val privateCloudName: Output<String>? = null,
    public val properties:
    Output<Either<WorkloadNetworkDhcpRelayArgs, WorkloadNetworkDhcpServerArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.WorkloadNetworkDhcpArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.WorkloadNetworkDhcpArgs =
        com.pulumi.azurenative.avs.WorkloadNetworkDhcpArgs.builder()
            .dhcpId(dhcpId?.applyValue({ args0 -> args0 }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadNetworkDhcpArgs].
 */
@PulumiTagMarker
public class WorkloadNetworkDhcpArgsBuilder internal constructor() {
    private var dhcpId: Output<String>? = null

    private var privateCloudName: Output<String>? = null

    private var properties:
        Output<Either<WorkloadNetworkDhcpRelayArgs, WorkloadNetworkDhcpServerArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value NSX DHCP identifier. Generally the same as the DHCP display name
     */
    @JvmName("jwwedrnwnfujbubp")
    public suspend fun dhcpId(`value`: Output<String>) {
        this.dhcpId = value
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("odkqcsxhpnfqxlvc")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value DHCP properties.
     */
    @JvmName("qsijbwgypomrugpi")
    public suspend
    fun properties(`value`: Output<Either<WorkloadNetworkDhcpRelayArgs, WorkloadNetworkDhcpServerArgs>>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lgkiioxuasoayijh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value NSX DHCP identifier. Generally the same as the DHCP display name
     */
    @JvmName("raeusyoderjryqyu")
    public suspend fun dhcpId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dhcpId = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("xgwklwkvpojwyrbx")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value DHCP properties.
     */
    @JvmName("lmvsuxijkwoqblbl")
    public suspend
    fun properties(`value`: Either<WorkloadNetworkDhcpRelayArgs, WorkloadNetworkDhcpServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value DHCP properties.
     */
    @JvmName("uomxuciquhctpesr")
    public fun properties(`value`: WorkloadNetworkDhcpRelayArgs) {
        val toBeMapped = Either.ofLeft<WorkloadNetworkDhcpRelayArgs,
            WorkloadNetworkDhcpServerArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value DHCP properties.
     */
    @JvmName("ottvwwwjoifnnayc")
    public fun properties(`value`: WorkloadNetworkDhcpServerArgs) {
        val toBeMapped = Either.ofRight<WorkloadNetworkDhcpRelayArgs,
            WorkloadNetworkDhcpServerArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pyjxhunagwrgjorl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): WorkloadNetworkDhcpArgs = WorkloadNetworkDhcpArgs(
        dhcpId = dhcpId,
        privateCloudName = privateCloudName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
