@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.WorkloadNetworkDnsZoneArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * NSX DNS Zone
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### WorkloadNetworks_CreateDnsZone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadNetworkDnsZone = new AzureNative.AVS.WorkloadNetworkDnsZone("workloadNetworkDnsZone", new()
 *     {
 *         DisplayName = "dnsZone1",
 *         DnsServerIps = new[]
 *         {
 *             "1.1.1.1",
 *         },
 *         DnsZoneId = "dnsZone1",
 *         Domain = new[] {},
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Revision = 1,
 *         SourceIp = "8.8.8.8",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewWorkloadNetworkDnsZone(ctx, "workloadNetworkDnsZone", &avs.WorkloadNetworkDnsZoneArgs{
 * 			DisplayName: pulumi.String("dnsZone1"),
 * 			DnsServerIps: pulumi.StringArray{
 * 				pulumi.String("1.1.1.1"),
 * 			},
 * 			DnsZoneId:         pulumi.String("dnsZone1"),
 * 			Domain:            pulumi.StringArray{},
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Revision:          pulumi.Float64(1),
 * 			SourceIp:          pulumi.String("8.8.8.8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.WorkloadNetworkDnsZone;
 * import com.pulumi.azurenative.avs.WorkloadNetworkDnsZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadNetworkDnsZone = new WorkloadNetworkDnsZone("workloadNetworkDnsZone", WorkloadNetworkDnsZoneArgs.builder()
 *             .displayName("dnsZone1")
 *             .dnsServerIps("1.1.1.1")
 *             .dnsZoneId("dnsZone1")
 *             .domain()
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .revision(1)
 *             .sourceIp("8.8.8.8")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:WorkloadNetworkDnsZone dnsZone1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/dnsZones/{dnsZoneId}
 * ```
 * @property displayName Display name of the DNS Zone.
 * @property dnsServerIps DNS Server IP array of the DNS Zone.
 * @property dnsServices Number of DNS Services using the DNS zone.
 * @property dnsZoneId NSX DNS Zone identifier. Generally the same as the DNS Zone's display name
 * @property domain Domain names of the DNS Zone.
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property revision NSX revision number.
 * @property sourceIp Source IP of the DNS Zone.
 */
public data class WorkloadNetworkDnsZoneArgs(
    public val displayName: Output<String>? = null,
    public val dnsServerIps: Output<List<String>>? = null,
    public val dnsServices: Output<Double>? = null,
    public val dnsZoneId: Output<String>? = null,
    public val domain: Output<List<String>>? = null,
    public val privateCloudName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val revision: Output<Double>? = null,
    public val sourceIp: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.WorkloadNetworkDnsZoneArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.WorkloadNetworkDnsZoneArgs =
        com.pulumi.azurenative.avs.WorkloadNetworkDnsZoneArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .dnsServerIps(dnsServerIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .dnsServices(dnsServices?.applyValue({ args0 -> args0 }))
            .dnsZoneId(dnsZoneId?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .revision(revision?.applyValue({ args0 -> args0 }))
            .sourceIp(sourceIp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadNetworkDnsZoneArgs].
 */
@PulumiTagMarker
public class WorkloadNetworkDnsZoneArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var dnsServerIps: Output<List<String>>? = null

    private var dnsServices: Output<Double>? = null

    private var dnsZoneId: Output<String>? = null

    private var domain: Output<List<String>>? = null

    private var privateCloudName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var revision: Output<Double>? = null

    private var sourceIp: Output<String>? = null

    /**
     * @param value Display name of the DNS Zone.
     */
    @JvmName("lxpmeeabbyrgxevm")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value DNS Server IP array of the DNS Zone.
     */
    @JvmName("thudesysjuwelqmf")
    public suspend fun dnsServerIps(`value`: Output<List<String>>) {
        this.dnsServerIps = value
    }

    @JvmName("ulskcuujooobsrbj")
    public suspend fun dnsServerIps(vararg values: Output<String>) {
        this.dnsServerIps = Output.all(values.asList())
    }

    /**
     * @param values DNS Server IP array of the DNS Zone.
     */
    @JvmName("xwguesbixfbcxtfh")
    public suspend fun dnsServerIps(values: List<Output<String>>) {
        this.dnsServerIps = Output.all(values)
    }

    /**
     * @param value Number of DNS Services using the DNS zone.
     */
    @JvmName("ddrxcibtmqdcgxxx")
    public suspend fun dnsServices(`value`: Output<Double>) {
        this.dnsServices = value
    }

    /**
     * @param value NSX DNS Zone identifier. Generally the same as the DNS Zone's display name
     */
    @JvmName("qgqfregplpgkidsw")
    public suspend fun dnsZoneId(`value`: Output<String>) {
        this.dnsZoneId = value
    }

    /**
     * @param value Domain names of the DNS Zone.
     */
    @JvmName("moxilnqydhrdbvoh")
    public suspend fun domain(`value`: Output<List<String>>) {
        this.domain = value
    }

    @JvmName("kiankgqkguishoug")
    public suspend fun domain(vararg values: Output<String>) {
        this.domain = Output.all(values.asList())
    }

    /**
     * @param values Domain names of the DNS Zone.
     */
    @JvmName("eljanaytrlcavios")
    public suspend fun domain(values: List<Output<String>>) {
        this.domain = Output.all(values)
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("uhnsglgsglamtlwg")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("adlnondlntqgrafi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value NSX revision number.
     */
    @JvmName("dhvmujyaipaqqmcf")
    public suspend fun revision(`value`: Output<Double>) {
        this.revision = value
    }

    /**
     * @param value Source IP of the DNS Zone.
     */
    @JvmName("yohnqqheubggfcil")
    public suspend fun sourceIp(`value`: Output<String>) {
        this.sourceIp = value
    }

    /**
     * @param value Display name of the DNS Zone.
     */
    @JvmName("vsaigaoamfovwdhj")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value DNS Server IP array of the DNS Zone.
     */
    @JvmName("gpkhpeixptwlsjps")
    public suspend fun dnsServerIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServerIps = mapped
    }

    /**
     * @param values DNS Server IP array of the DNS Zone.
     */
    @JvmName("cpvflcsqvfwlyspn")
    public suspend fun dnsServerIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServerIps = mapped
    }

    /**
     * @param value Number of DNS Services using the DNS zone.
     */
    @JvmName("ymutupmidasfbpaa")
    public suspend fun dnsServices(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServices = mapped
    }

    /**
     * @param value NSX DNS Zone identifier. Generally the same as the DNS Zone's display name
     */
    @JvmName("bocgptvkyfooujmu")
    public suspend fun dnsZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsZoneId = mapped
    }

    /**
     * @param value Domain names of the DNS Zone.
     */
    @JvmName("tgpmrsbvxlogcvki")
    public suspend fun domain(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param values Domain names of the DNS Zone.
     */
    @JvmName("eycghbcrituuxyfd")
    public suspend fun domain(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("uyicdbgxsbovphjf")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wbwcbaucixmhfkji")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value NSX revision number.
     */
    @JvmName("ilxagetfdqykaiys")
    public suspend fun revision(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revision = mapped
    }

    /**
     * @param value Source IP of the DNS Zone.
     */
    @JvmName("rlrytjqbgphlhhjw")
    public suspend fun sourceIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIp = mapped
    }

    internal fun build(): WorkloadNetworkDnsZoneArgs = WorkloadNetworkDnsZoneArgs(
        displayName = displayName,
        dnsServerIps = dnsServerIps,
        dnsServices = dnsServices,
        dnsZoneId = dnsZoneId,
        domain = domain,
        privateCloudName = privateCloudName,
        resourceGroupName = resourceGroupName,
        revision = revision,
        sourceIp = sourceIp,
    )
}
