@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.WorkloadNetworkPublicIPArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * NSX Public IP Block
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2021-06-01.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### WorkloadNetworks_CreatePublicIP
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadNetworkPublicIP = new AzureNative.AVS.WorkloadNetworkPublicIP("workloadNetworkPublicIP", new()
 *     {
 *         DisplayName = "publicIP1",
 *         NumberOfPublicIPs = 32,
 *         PrivateCloudName = "cloud1",
 *         PublicIPId = "publicIP1",
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewWorkloadNetworkPublicIP(ctx, "workloadNetworkPublicIP", &avs.WorkloadNetworkPublicIPArgs{
 * 			DisplayName:       pulumi.String("publicIP1"),
 * 			NumberOfPublicIPs: pulumi.Float64(32),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			PublicIPId:        pulumi.String("publicIP1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.WorkloadNetworkPublicIP;
 * import com.pulumi.azurenative.avs.WorkloadNetworkPublicIPArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadNetworkPublicIP = new WorkloadNetworkPublicIP("workloadNetworkPublicIP", WorkloadNetworkPublicIPArgs.builder()
 *             .displayName("publicIP1")
 *             .numberOfPublicIPs(32)
 *             .privateCloudName("cloud1")
 *             .publicIPId("publicIP1")
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:WorkloadNetworkPublicIP publicIP1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/publicIPs/{publicIPId}
 * ```
 * @property displayName Display name of the Public IP Block.
 * @property numberOfPublicIPs Number of Public IPs requested.
 * @property privateCloudName Name of the private cloud
 * @property publicIPId NSX Public IP Block identifier. Generally the same as the Public IP Block's display name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class WorkloadNetworkPublicIPArgs(
    public val displayName: Output<String>? = null,
    public val numberOfPublicIPs: Output<Double>? = null,
    public val privateCloudName: Output<String>? = null,
    public val publicIPId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.WorkloadNetworkPublicIPArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.WorkloadNetworkPublicIPArgs =
        com.pulumi.azurenative.avs.WorkloadNetworkPublicIPArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .numberOfPublicIPs(numberOfPublicIPs?.applyValue({ args0 -> args0 }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .publicIPId(publicIPId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadNetworkPublicIPArgs].
 */
@PulumiTagMarker
public class WorkloadNetworkPublicIPArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var numberOfPublicIPs: Output<Double>? = null

    private var privateCloudName: Output<String>? = null

    private var publicIPId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Display name of the Public IP Block.
     */
    @JvmName("talhfknrqtdahcdf")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Number of Public IPs requested.
     */
    @JvmName("meysxrlbndivdnsu")
    public suspend fun numberOfPublicIPs(`value`: Output<Double>) {
        this.numberOfPublicIPs = value
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("wpngcwqmyljccnji")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value NSX Public IP Block identifier. Generally the same as the Public IP Block's display name
     */
    @JvmName("gqsrmjwomjcggvom")
    public suspend fun publicIPId(`value`: Output<String>) {
        this.publicIPId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("itvdxvlllmvmpirx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Display name of the Public IP Block.
     */
    @JvmName("jyoxnuluuhhhhunl")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Number of Public IPs requested.
     */
    @JvmName("mapvcopsuhhqtspb")
    public suspend fun numberOfPublicIPs(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfPublicIPs = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("sefeisunpcxiafni")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value NSX Public IP Block identifier. Generally the same as the Public IP Block's display name
     */
    @JvmName("xhwawrykgofuhrbr")
    public suspend fun publicIPId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("niftyimlofwgcovf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): WorkloadNetworkPublicIPArgs = WorkloadNetworkPublicIPArgs(
        displayName = displayName,
        numberOfPublicIPs = numberOfPublicIPs,
        privateCloudName = privateCloudName,
        publicIPId = publicIPId,
        resourceGroupName = resourceGroupName,
    )
}
