@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetDatastorePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName Name of the cluster in the private cloud
 * @property datastoreName Name of the datastore in the private cloud cluster
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDatastorePlainArgs(
    public val clusterName: String,
    public val datastoreName: String,
    public val privateCloudName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetDatastorePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetDatastorePlainArgs =
        com.pulumi.azurenative.avs.inputs.GetDatastorePlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .datastoreName(datastoreName.let({ args0 -> args0 }))
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDatastorePlainArgs].
 */
@PulumiTagMarker
public class GetDatastorePlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var datastoreName: String? = null

    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the cluster in the private cloud
     */
    @JvmName("ttykxfodrsctjvkx")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value Name of the datastore in the private cloud cluster
     */
    @JvmName("kixaypgpmkpddrnu")
    public suspend fun datastoreName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.datastoreName = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("duoijindevonndwl")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vollufdorouivodl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDatastorePlainArgs = GetDatastorePlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        datastoreName = datastoreName ?: throw PulumiNullFieldException("datastoreName"),
        privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
