@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetGlobalReachConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property globalReachConnectionName Name of the global reach connection in the private cloud
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetGlobalReachConnectionPlainArgs(
    public val globalReachConnectionName: String,
    public val privateCloudName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetGlobalReachConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetGlobalReachConnectionPlainArgs =
        com.pulumi.azurenative.avs.inputs.GetGlobalReachConnectionPlainArgs.builder()
            .globalReachConnectionName(globalReachConnectionName.let({ args0 -> args0 }))
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGlobalReachConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetGlobalReachConnectionPlainArgsBuilder internal constructor() {
    private var globalReachConnectionName: String? = null

    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the global reach connection in the private cloud
     */
    @JvmName("cwnsvbkagqpctthg")
    public suspend fun globalReachConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalReachConnectionName = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("fodvnwovlojahyxa")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yxblqrwrjaijfvic")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGlobalReachConnectionPlainArgs = GetGlobalReachConnectionPlainArgs(
        globalReachConnectionName = globalReachConnectionName ?: throw
            PulumiNullFieldException("globalReachConnectionName"),
        privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
