@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetPrivateCloudPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPrivateCloudPlainArgs(
    public val privateCloudName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetPrivateCloudPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetPrivateCloudPlainArgs =
        com.pulumi.azurenative.avs.inputs.GetPrivateCloudPlainArgs.builder()
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateCloudPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateCloudPlainArgsBuilder internal constructor() {
    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the private cloud
     */
    @JvmName("xfkmhpcpnrwhtkvx")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yigpllumpgbncsan")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateCloudPlainArgs = GetPrivateCloudPlainArgs(
        privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
