@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.ListClusterZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName Name of the cluster in the private cloud
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListClusterZonesPlainArgs(
    public val clusterName: String,
    public val privateCloudName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.ListClusterZonesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.ListClusterZonesPlainArgs =
        com.pulumi.azurenative.avs.inputs.ListClusterZonesPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListClusterZonesPlainArgs].
 */
@PulumiTagMarker
public class ListClusterZonesPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the cluster in the private cloud
     */
    @JvmName("hqbeofbhjnjhxmkh")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("vqpldkndrytadxpi")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("intafnsvtehsjads")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListClusterZonesPlainArgs = ListClusterZonesPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
