@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of an Arc addon
 * @property addonType The type of private cloud addon
 * Expected value is 'Arc'.
 * @property provisioningState The state of the addon provisioning
 * @property vCenter The VMware vCenter resource ID
 */
public data class AddonArcPropertiesResponse(
    public val addonType: String,
    public val provisioningState: String,
    public val vCenter: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.AddonArcPropertiesResponse):
            AddonArcPropertiesResponse = AddonArcPropertiesResponse(
            addonType = javaType.addonType(),
            provisioningState = javaType.provisioningState(),
            vCenter = javaType.vCenter().map({ args0 -> args0 }).orElse(null),
        )
    }
}
